///////////////////////////////////////////////////////////////////////////
/// 
/// \addtogroup Log
/// @{
/// \file ILog.h
/// 
/// This is the interface for all log classes. This log interface allows to
/// put a single log entry to several sinks like file or database
///
/// \copyright (c) Copyright 2012 
///////////////////////////////////////////////////////////////////////////

#ifndef INCLUDEGUARD_ILOG_H
#define INCLUDEGUARD_ILOG_H

///////////////////////////////////////////////////////////////////////////
//  Includes
///////////////////////////////////////////////////////////////////////////



///////////////////////////////////////////////////////////////////////////
//  Definitions
///////////////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////////////
/// This is the interface for all log classes. Here is the detailed 
/// description of the class so the application developer knows, 
/// what this class is used for
///////////////////////////////////////////////////////////////////////////
class ILog {
    public:
		/// An enum type.      
		/// The documentation block cannot be put after the enum!      
		enum EEnumType {
			EVal1,     /**< enum value 1 */
			EVal2      /**< enum value 2 */
		};


		/// An other enum type. Put here some more text.
		/// An there is another line...
		enum EEnumeType2 {
			EValA,		///< enum val A
			EValB		///< enum val B
		};
		
		///////////////////////////////////////////////////////////////////////////
		/// brief description of function. Details to the function... there might
		/// be several lines to describe the function
		/// 
		/// \param p__nCount Quantity of log entries
		/// \return Number of log entries accepted
		/// \sa other log functions nLogNoDetails and nLogNoDetails2
		/// \note This is the note section
		/// \warning This function is globally synchronized, be careful with high prio threads
		///////////////////////////////////////////////////////////////////////////
		virtual int nLog(int p__nCount) = 0;

		///////////////////////////////////////////////////////////////////////////
		/// Add brief description here. Add description here
		/// 
		/// \param p__nCount Quantity of log entries
		/// \return Number of log entries accepted
		/// \warning This function is globally synchronized, be careful with high prio threads
		///////////////////////////////////////////////////////////////////////////
		virtual int nLogNoDetails(int p__nCount) = 0;
		
		///////////////////////////////////////////////////////////////////////////
		/// Brief description here. Details to the function... there might be several lines
		/// to describe the function
		/// 
		/// \param p__nCount Quantity of log entries
		/// \return Number of log entries accepted
		///////////////////////////////////////////////////////////////////////////
		virtual int nLogNoDetails2(int p__nCount) = 0;
};

#endif //INCLUDEGUARD_ILOG_H
/// @} 
