@echo off

::
:: Build script for the UltraDefrag project documentation.
:: Copyright (c) 2007-2012 Dmitri Arkhangelski (dmitriar@gmail.com).
:: Copyright (c) 2010-2012 Stefan Pendl (stefanpe@users.sourceforge.net).
::
:: This program is free software; you can redistribute it and/or modify
:: it under the terms of the GNU General Public License as published by
:: the Free Software Foundation; either version 2 of the License, or
:: (at your option) any later version.
::
:: This program is distributed in the hope that it will be useful,
:: but WITHOUT ANY WARRANTY; without even the implied warranty of
:: MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
:: GNU General Public License for more details.
::
:: You should have received a copy of the GNU General Public License
:: along with this program; if not, write to the Free Software
:: Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
::

echo Build UltraDefrag development docs...
echo.

call :compile_docs . || goto fail

:: compile PDF documentation if MiKTeX is installed
pdflatex --version >nul 2>&1
if not errorlevel 1 (
    call :compile_pdf . a4     || goto fail
    call :compile_pdf . letter || goto fail
)

echo.
echo Docs compiled successfully!
exit /B 0

:fail
echo.
echo Docs compilation failed!
exit /B 1

rem Synopsis: call :compile_docs {path} {name}
rem Note:     omit the second parameter to prevent copying docs to /src/doxy-doc directory
rem Example:  call :compile_docs .\dll\zenwinx zenwinx
:compile_docs
    pushd %1
    rd /s /q doxy-doc
    doxygen || goto compilation_failed

    del /Q .\doxy-doc\html\doxygen.png

    :compilation_succeeded
    popd
    exit /B 0
    :compilation_failed
    popd
    exit /B 1
goto :EOF

rem Synopsis: call :compile_pdf {path} {paper size} {PDF name}
rem Example:  call :compile_pdf ..\doc\handbook letter UltraDefrag_Handbook
:compile_pdf
    pushd %1
    rd /s /q doxy-doc\latex_%2

    copy /v /y Doxyfile Doxyfile_%2
    (
        echo GENERATE_HTML          = NO
        echo GENERATE_LATEX         = YES
        echo LATEX_OUTPUT           = latex_%2
        echo PAPER_TYPE             = %2
        echo LATEX_HEADER           = ./rsc/custom_header_%2.tex
    ) >>Doxyfile_%2
    
    doxygen Doxyfile_%2 || goto compilation_failed

    copy /Y .\rsc\*.png .\doxy-doc\latex_%2
    copy /Y .\rsc\*.sty .\doxy-doc\latex_%2

    :compilation_succeeded
    pushd doxy-doc\latex_%2

    call make.bat

    popd
    del /f /q Doxyfile_%2
    popd
    exit /B 0
    :compilation_failed
    popd
    del /f /q Doxyfile_%2
    popd
    exit /B 1
goto :EOF
