//
//  AppDelegate.m
//  GStreamerExample
//
//  Created by Gerard Toonstra on 8/13/12.
//  Copyright (c) 2012 Gerard Toonstra. All rights reserved.
//

#import "AppDelegate.h"
#import "VideoView.h"

#include <gst/gst.h>

/* ============================================================= */
/*                                                               */
/*                   gstreamer callbacks                         */
/*                                                               */
/* ============================================================= */
typedef struct context_t {
    void *appDelegate;
    void *viewingArea;
} context_t;

static GMainLoop *loop;

static gboolean bus_call(GstBus *bus, GstMessage *msg, void *user_data)
{
    context_t *context;
    
    switch (GST_MESSAGE_TYPE(msg)) {
        case GST_MESSAGE_EOS: {
            g_message("End-of-stream");
            g_main_loop_quit(loop);
            break;
        }
        case GST_MESSAGE_ERROR: {
            GError *err;
            gst_message_parse_error(msg, &err, NULL);
            g_error("%s", err->message);
            g_error_free(err);
            
            g_main_loop_quit(loop);
            break;
        }
        default:
            context = (context_t *)user_data;
            if (( msg != NULL ) && ( msg->structure != NULL )) {
                if (gst_structure_has_name(msg->structure, "have-ns-view")) {
                    NSView* myView = (__bridge NSView*)g_value_get_pointer(gst_structure_get_value(msg->structure, "nsview"));
                    VideoView *customView = (__bridge VideoView*)context->viewingArea;
                    NSRect viewFrame = [(__bridge NSView*)context->viewingArea frame];
                    [myView setFrame: viewFrame];
                    [myView setNeedsDisplay:YES];
                    [customView addSubview:myView];
                }
            }
            
            break;
    }
    
    return true;
}

static void gst_finish(GstElement* object, gpointer user_data)
{
    //set uri to the next clip
}

static void play_uri(const char *uri, void *user_data)
{
    GstElement *pipeline;
    GstBus *bus;
       
    loop = g_main_loop_new(NULL, FALSE);
    
    // We're not using the uri here, but just go for the video test src to
    // describe the concept.
    //
    //pipeline = gst_element_factory_make("playbin2", "player");
    //if (uri)
    //    g_object_set(G_OBJECT(pipeline), "uri", uri, NULL);
    
    pipeline = gst_pipeline_new ("my-pipeline");
    GstElement *src = gst_element_factory_make ("videotestsrc", "src");
    if (src == NULL)
        g_error ("Could not create 'videotestsrc' element");

    GstElement *scale = gst_element_factory_make ("videoscale", "scale");
    if (scale == NULL)
        g_error ("Could not create 'videoscale' element");

    GstElement *filter = gst_element_factory_make ("capsfilter", "filter");
    g_assert ( filter != NULL); /* should always exist */
    
    GstElement *sink = gst_element_factory_make ("osxvideosink", "sink");
    if (sink == NULL) {
        g_error ("Could not create 'osxvideosink' element");
    }
    g_object_set( G_OBJECT( sink ), "embed", true, NULL );
    
    gst_bin_add_many (GST_BIN (pipeline), src, scale, filter, sink, NULL);
    gst_element_link_many (src, scale, filter, sink, NULL);
    GstCaps *filtercaps = gst_caps_new_simple ("video/x-raw-yuv",
                                      "width", G_TYPE_INT, 640,
                                      "height", G_TYPE_INT, 480,
                                      NULL);
    g_object_set (G_OBJECT (filter), "caps", filtercaps, NULL);
    gst_caps_unref (filtercaps);
    // Replace the above code to test different pipelines
    
    bus = gst_pipeline_get_bus(GST_PIPELINE(pipeline));
    gst_bus_add_watch(bus, bus_call, user_data);
    gst_object_unref(bus);
    
    // Another line that belonged to the playbin...
    //g_signal_connect(pipeline, "about-to-finish", G_CALLBACK(gst_finish), user_data);
    
    gst_element_set_state(GST_ELEMENT(pipeline), GST_STATE_PLAYING);
    
    g_main_loop_run(loop);
    
    gst_element_set_state(GST_ELEMENT(pipeline), GST_STATE_NULL);
    gst_object_unref(GST_OBJECT(pipeline));
}

@implementation AppDelegate
@synthesize viewingArea = _viewingArea;

-(void)g_init:(id)param
{
    gst_init(NULL, NULL);
    context_t *context = malloc(sizeof(context_t));
    context->appDelegate = (__bridge void*)self;
    context->viewingArea = (__bridge void*)self.viewingArea;
    play_uri("file:///Users/Shared/movies/holiday.mp4", context);
}

- (void)applicationDidFinishLaunching:(NSNotification *)aNotification
{
    NSThread *g_thread = [[NSThread alloc] initWithTarget:self selector:@selector(g_init:) object:nil];
    [g_thread start];
}

@end
