#ifndef HOMESKIN_H
#define HOMESKIN_H

#include "homeskin_global.h"
#include <QWidget>

namespace Ui {class HomeSkin;};

namespace Company { namespace Project { namespace Skins {

////////////////////////////////////////////////////////////////////////////////////////////////////
/// \brief  Home skin. 
/// 
/// This skin is the main skin. 
////////////////////////////////////////////////////////////////////////////////////////////////////
class HOMESKIN_EXPORT HomeSkin : public QWidget
{
    Q_OBJECT

public:

    ////////////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief  Constructor. 
    /// 
    /// Creates an home skin.
    ///
    /// \param [in,out] parent  If non-null, the parent widget. 
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    HomeSkin(QWidget* parent = 0);

    ////////////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief  Destructor. 
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    virtual ~HomeSkin();

public:

    ////////////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief  Initializes the home skin. 
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    virtual void initialize();

    ////////////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief  Terminates the home skin. 
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    virtual void terminate();

signals:

    ////////////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief  Signal emitted when a quit request is made. 
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    void quitRequest();

private slots:

    ////////////////////////////////////////////////////////////////////////////////////////////////////
    /// \brief  Handle exam button clicked signals. 
    ///
    /// \param  id  The exam identifier. 
    ////////////////////////////////////////////////////////////////////////////////////////////////////
    void handleExamButtonClicked(int id);

private:
    Ui::HomeSkin* _ui;      ///< The home skin user interface
};

} } } // namespace Company::Project::Skins

#endif // HOMESKIN_H
