#include <libxml/xmlschemas.h>
#include <libxml/xmlschemastypes.h>
#include <libxml/xmlschemastrans.h>
#include <libxml/parser.h>
#include <libxml/tree.h>

static xmlNsPtr xsiNs;
static int nsinit = 0;
static int thingcount = -1;

typedef struct {
    char *path;
    char *fixed;
    char *(*fill)(void *ctx, xmlNode *tnode, xmlChar *path);
} MAP;

#define T1(x)	((struct t1 *)x)
#define T2(x)	((struct t2 *)x)

struct thing {	/* corresponds to FooThing */
    char *ftbar;
    int ftbarbar;
};

struct t1 {	/* FooThingOne */
    struct thing foothing;
    /* empty extension */
};

struct t2 {	/* FooThingTwo */
    struct thing foothing;
    /* extension */
    char *extra1;
    char *extra2;
    char *extra3;
};

struct FOO {
    char *bar;
    int blob;
    struct thing *list[5];
};

static char *
foobar(void *ctx, xmlNodePtr node, xmlChar *path)
{
    struct FOO *data = (struct FOO *)ctx; 

    if (!data)
	return NULL;
    return data->bar;
}

static char *
fooblob(void *ctx, xmlNodePtr node, xmlChar *path)
{
    static char num[64];
    struct FOO *data = (struct FOO *)ctx; 

    if (!data)
	return NULL;
    snprintf(num, 64, "%d", data->blob);
    return num;
}

static int another;

static char *
thingidx(void *ctx, xmlNodePtr node, xmlChar *path)
{
    struct FOO *data = (struct FOO *)ctx; 

    if (!data)
	return NULL;
    if (!xmlStrEqual(path, "/Foo:Foo/FooBarList/FooThing") &&
	!xmlStrEqual(path, "/Foo:Foo/FooBarList/FooThing[2]"))
	return NULL;
    puts("thing idx");
    thingcount++;
    if (data->list[thingcount+1])
	another = 1;
    return NULL;
}

static char *
thingseq(void *ctx, xmlNodePtr node, xmlChar *path)
{
    static char num[64];
    struct FOO *data = (struct FOO *)ctx; 

    if (!data)
	return NULL;

    snprintf(num, 64, "%d", thingcount+1);
    return num;
}

static char *
ftbar(void *ctx, xmlNodePtr node, xmlChar *path)
{
    struct FOO *data = (struct FOO *)ctx; 

    if (thingcount < 0 || !data->list[thingcount])
	return NULL;
    return T1(data->list[thingcount])->foothing.ftbar;
}

static char *
ftbarbar(void *ctx, xmlNodePtr node, xmlChar *path)
{
    static char num[64];
    struct FOO *data = (struct FOO *)ctx; 

    if (thingcount < 0 || !data->list[thingcount])
	return NULL;
    snprintf(num, 64, "%d", T1(data->list[thingcount])->foothing.ftbarbar);
    return num;
}

static MAP datamapping[] = {
    { "/Foo:Foo/FooBarList/FooThing/FTBarBar", NULL, ftbarbar },
    { "/Foo:Foo/FooBarList/FooThing/FTBar", NULL, ftbar },
    { "/Foo:Foo/FooBarList/FooThing/@Seq", NULL, thingseq },
    { "/Foo:Foo/FooBarList/FooThing[2]/FTBarBar", NULL, ftbarbar },
    { "/Foo:Foo/FooBarList/FooThing[2]/FTBar", NULL, ftbar },
    { "/Foo:Foo/FooBarList/FooThing[2]/@Seq", NULL, thingseq },
    { "/Foo:Foo/FooBarList/FooThing", NULL, thingidx },
    { "/Foo:Foo/FooBarList", NULL, NULL },
    { "/Foo:Foo/FooBar", NULL, foobar },
    { "/Foo:Foo/FooBlob", NULL, fooblob },
    { "/Foo:Foo/Fooey", "Literal Value", NULL },
    { NULL, 0, 0 }
};

static MAP transmapping[] = {
    { "/Foo:Foo/FooBarList/FooThing", "bar:FooThingOne", NULL },
    { NULL, 0, 0 }
};

static xmlSchemaTranslatorStatus
dataCB(void *ctx, xmlNodePtr snode, xmlNodePtr tnode, xmlAttrPtr attr, xmlSchemaTranslatorAction action)
{
    xmlSchemaTranslatorStatus ret = XSD_TRS_EXCLUDE;
    xmlChar *path;
    char *cp;
    int i;

    path = xmlGetNodePath(tnode);
    if (attr) {
	path = xmlStrncat(path, BAD_CAST "/@", 2);
	path = xmlStrcat(path, attr->name);
    }

    printf("fillcb: %s\n", path);
    cp = NULL;
    for (i = 0; datamapping[i].path && !cp; i++)
    {
	if (xmlStrncmp(BAD_CAST datamapping[i].path, path,
		       strlen(datamapping[i].path)) == 0)
	{
	    another = 0;
	    if (datamapping[i].fixed)
		cp = datamapping[i].fixed;
	    else if (datamapping[i].fill)
		cp = (*datamapping[i].fill)(ctx, tnode, path);
	    if (cp)
	    {
		/* content return on complex type simply indicates more to come */
		if (attr)
		    xmlSetNsProp(tnode, NULL, attr->name, BAD_CAST cp);
		else
		    xmlNodeAddContent(tnode, BAD_CAST cp);
		ret = XSD_TRS_CONTENT;
	    }
	    ret = another ? XSD_TRS_MORECONTENT : XSD_TRS_EXCLUDE;
	    break;
	}
    }
    if (!cp)
	return ret;
    return ret;
}

static xmlSchemaTranslatorStatus
translatorCB(void *ctx, xmlNodePtr snode, xmlNodePtr tnode, xmlAttrPtr attr, xmlSchemaTranslatorAction action)
{
    xmlSchemaTranslatorStatus ret = XSD_TRS_DEFER;
    xmlChar *path;
    int i;
    char *cp;

    /* At the very beginning, setup any namespace references we'll need */
    if (!nsinit)
    {
	xmlNodePtr root = xmlDocGetRootElement(tnode->doc);
	nsinit = 1;
	/*
	  I cleaned this up by defining an array of mappings which I loop
	  through to setup the prefixes required. This simple demo only
	  requires the one.
	 */
	xmlNewNs(root, BAD_CAST "http://Whatever.com/Bar", BAD_CAST "bar");
    }

    path = xmlGetNodePath(tnode);
    if (attr) {
	path = xmlStrncat(path, BAD_CAST "/@", 2);
	path = xmlStrcat(path, attr->name);
    }

    switch(action)
    {
	case XSD_TRA_FILL:
	    printf("fill: %s\n", path);
	    cp = NULL;
	    for (i = 0; datamapping[i].path && !cp; i++)
	    {
		if (xmlStrncmp(BAD_CAST datamapping[i].path, path,
			       strlen(datamapping[i].path)) == 0)
		{
		    another = 0;
		    if (datamapping[i].fixed)
			cp = datamapping[i].fixed;
		    else if (datamapping[i].fill)
			cp = (*datamapping[i].fill)(ctx, tnode, path);
		    if (cp)
		    {
			/* content return on complex type simply indicates more to come */
			if (attr)
			    xmlSetNsProp(tnode, NULL, attr->name, BAD_CAST cp);
			else
			    xmlNodeAddContent(tnode, BAD_CAST cp);
			ret = XSD_TRS_CONTENT;
		    }
		    else
			ret = another ? XSD_TRS_MORECONTENT : XSD_TRS_EXCLUDE;
		    break;
		}
	    }
	    if (!cp)
		return XSD_TRS_EXCLUDE;
	    break;
	case XSD_TRA_RESOLVE:
	    printf("resolve: %s\n", path);
	    if (!xsiNs) {
		xsiNs = xmlSearchNs(NULL, tnode, "xsi");
	    }
	    for (i = 0; transmapping[i].path; i++)
	    {
		/* resolve abstract here */
		if (xmlStrEqual(BAD_CAST transmapping[i].path, path))
		{
		    char *cp;

		    if (transmapping[i].fixed)
			cp = transmapping[i].fixed;
		    else if (transmapping[i].fill)
			cp = (*transmapping[i].fill)(ctx, tnode, path);

		    if (cp)
		    {
			/* this sets xsi:type for abstract types */
			xmlNewNsProp(tnode, xsiNs, (xmlChar *)"type", BAD_CAST cp);
			ret = XSD_TRS_STRUCTURE;
		    }
		    else
			ret = XSD_TRS_EXCLUDE;
		    break;
		}
	    }
	    break;
	default:
	    break;
    }
    return ret;
}

int
main(int ac, char **av)
{
    xmlSchemaParserCtxtPtr ctxt;
    xmlSchemaValidCtxt *validityContext;
    xmlSchemaPtr schema;
    xmlDocTemplatePtr tmpl;
    xmlDocPtr doc;
    char line[256];
    struct FOO dat;

    LIBXML_TEST_VERSION
	    ;

    /* Setup some dummy data */
    dat.bar = "Foo string";
    dat.blob = 9876;
    dat.list[0] = NULL;
    /*parse the file and get the schema */
    ctxt = xmlSchemaNewParserCtxt(av[1]);
    xmlSchemaSetParserErrors(ctxt,
			     (xmlSchemaValidityErrorFunc) fprintf,
			     (xmlSchemaValidityWarningFunc) fprintf,
			     stderr);
    schema = xmlSchemaParse(ctxt);
    puts("Making template...");
    tmpl = xmlSchemaMakeTemplate(schema, translatorCB, NULL);

    /* Setup more dummy data */
    dat.list[0] = (struct thing *)calloc(1, sizeof(struct t1));
    T1(dat.list[0])->foothing.ftbar = "bar string";
    T1(dat.list[0])->foothing.ftbarbar = 101010;
    dat.list[1] = (struct thing *)calloc(1, sizeof(struct t1));
    T1(dat.list[1])->foothing.ftbar = "foo string";
    T1(dat.list[1])->foothing.ftbarbar = 373737;
    dat.list[2] = NULL;

    puts("Making document...");
    thingcount = -1;	/* reset */
    doc = xmlSchemaMakeDoc(tmpl, dataCB, &dat);
    xmlDocFormatDump(stdout, doc, 1);

    return 0;
}
