/*
 * Decompiled with CFR 0.152.
 */
package com.stattmann.swing;

import java.awt.AWTEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class DebugOutput
extends JScrollPane {
    private String newline = "\n";
    private JTextArea output = (JTextArea)this.getViewport().getView();

    public DebugOutput(int rows, int columns) {
        super(new JTextArea(rows, columns));
        this.output.setName("debug-output-area");
        this.output.setEditable(true);
        this.output.setLineWrap(true);
        this.output.setWrapStyleWord(true);
    }

    private void printAE(ActionEvent e) {
        AbstractButton source = (AbstractButton)e.getSource();
        String s = "Action event detected." + this.newline + "    Event source: " + source.getText() + " (an instance of " + this.getClassName(source) + ")" + ", ActionCommand: " + e.getActionCommand() + ", ParameterString: " + e.paramString();
        this.output.append(s + this.newline);
    }

    private void printIE(ItemEvent e) {
        JMenuItem source = (JMenuItem)e.getSource();
        String s = "Item event detected." + this.newline + "    Event source: " + source.getText() + " (an instance of " + this.getClassName(source) + ")" + this.newline + "    New state: " + (e.getStateChange() == 1 ? "selected" : "unselected");
        this.output.append(s + this.newline);
    }

    private void printME(MouseEvent e) {
        JComponent source = (JComponent)e.getSource();
        String s = "Action event detected." + this.newline + "    Event source: " + source.getName() + " (an instance of " + this.getClassName(source) + ")" + ", When: " + e.getWhen() + ", Location: " + e.getX() + ", " + e.getY() + ", Button: " + e.getButton() + ", ClickCount: " + e.getClickCount() + ", MouseModifiers: " + MouseEvent.getMouseModifiersText(e.getModifiers()) + ", ModifiersEx: " + MouseEvent.getModifiersExText(e.getModifiersEx());
        this.output.append(s + this.newline);
    }

    public void print(AWTEvent e) {
        if (e instanceof ActionEvent) {
            this.printAE((ActionEvent)e);
        } else if (e instanceof ItemEvent) {
            this.printIE((ItemEvent)e);
        } else if (e instanceof MouseEvent) {
            this.printME((MouseEvent)e);
        } else {
            Object source = e.getSource();
            String s = "Other AWTEvent detected." + this.newline + "    Event source: " + source.toString() + " (an instance of " + this.getClassName(source) + ")" + this.newline + "    id: " + e.getID();
            this.output.append(s + this.newline);
        }
    }

    public void print(String s) {
        this.output.append(s);
    }

    protected String getClassName(Object o) {
        String classString = o.getClass().getName();
        int dotIndex = classString.lastIndexOf(".");
        return classString.substring(dotIndex + 1);
    }

    public void flush() {
        Document doc = this.output.getDocument();
        try {
            doc.remove(0, doc.getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }
}

