/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.DesktopProperty;
import com.sun.java.swing.plaf.windows.WindowsIconFactory;
import com.sun.java.swing.plaf.windows.WindowsPopupFactory;
import com.sun.java.swing.plaf.windows.WindowsPopupMenuUI;
import com.sun.java.swing.plaf.windows.WindowsTreeUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.security.AccessController;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.MenuSelectionManager;
import javax.swing.PopupFactory;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicLookAndFeel;
import sun.awt.shell.ShellFolder;
import sun.java2d.SunGraphicsEnvironment;
import sun.security.action.GetPropertyAction;

public class MyWindowsLookAndFeel
extends BasicLookAndFeel {
    private Toolkit toolkit;
    private boolean updatePending = false;
    private boolean useSystemFontSettings = true;
    private boolean useSystemFontSizeSettings;
    static boolean useNativeAnimation = true;
    private static boolean isMnemonicHidden = true;
    private static boolean isClassicWindows = false;

    public String getName() {
        return "Windows";
    }

    public String getDescription() {
        return "The Microsoft Windows Look and Feel";
    }

    public String getID() {
        return "Windows";
    }

    public boolean isNativeLookAndFeel() {
        String osName = System.getProperty("os.name");
        return osName != null && osName.indexOf("Windows") != -1;
    }

    public boolean isSupportedLookAndFeel() {
        return true;
    }

    public void initialize() {
        String nativeAnimation;
        this.toolkit = Toolkit.getDefaultToolkit();
        isClassicWindows = true;
        String systemFonts = AccessController.doPrivileged(new GetPropertyAction("swing.useSystemFontSettings"));
        boolean bl = this.useSystemFontSettings = systemFonts == null || Boolean.valueOf(systemFonts) != false;
        if (this.useSystemFontSettings) {
            Object value = UIManager.get("Application.useSystemFontSettings");
            this.useSystemFontSettings = value == null || Boolean.TRUE.equals(value);
        }
        boolean bl2 = useNativeAnimation = (nativeAnimation = AccessController.doPrivileged(new GetPropertyAction("swing.useNativeAnimation"))) == null ? false : nativeAnimation.equals("true");
        if (!isClassicWindows) {
            PopupFactory.setSharedInstance((PopupFactory)new WindowsPopupFactory());
        }
    }

    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        String windowsPackageName = "com.sun.java.swing.plaf.windows.";
        Object[] uiDefaults = new Object[]{"ButtonUI", windowsPackageName + "WindowsButtonUI", "CheckBoxUI", windowsPackageName + "WindowsCheckBoxUI", "LabelUI", windowsPackageName + "WindowsLabelUI", "RadioButtonUI", windowsPackageName + "WindowsRadioButtonUI", "ToggleButtonUI", windowsPackageName + "WindowsToggleButtonUI", "ProgressBarUI", windowsPackageName + "WindowsProgressBarUI", "SplitPaneUI", windowsPackageName + "WindowsSplitPaneUI", "TextAreaUI", windowsPackageName + "WindowsTextAreaUI", "TextFieldUI", windowsPackageName + "WindowsTextFieldUI", "PasswordFieldUI", windowsPackageName + "WindowsPasswordFieldUI", "TextPaneUI", windowsPackageName + "WindowsTextPaneUI", "EditorPaneUI", windowsPackageName + "WindowsEditorPaneUI", "TreeUI", windowsPackageName + "WindowsTreeUI", "ToolBarUI", windowsPackageName + "WindowsToolBarUI", "ToolBarSeparatorUI", windowsPackageName + "WindowsSeparatorUI", "ComboBoxUI", windowsPackageName + "WindowsComboBoxUI", "InternalFrameUI", windowsPackageName + "WindowsInternalFrameUI", "DesktopPaneUI", windowsPackageName + "WindowsDesktopPaneUI", "DesktopIconUI", windowsPackageName + "WindowsDesktopIconUI", "FileChooserUI", windowsPackageName + "WindowsFileChooserUI", "MenuUI", windowsPackageName + "WindowsMenuUI", "MenuItemUI", windowsPackageName + "WindowsMenuItemUI", "MenuBarUI", windowsPackageName + "WindowsMenuBarUI", "PopupMenuUI", windowsPackageName + "WindowsPopupMenuUI", "ScrollBarUI", windowsPackageName + "WindowsScrollBarUI", "RootPaneUI", windowsPackageName + "WindowsRootPaneUI"};
        table.putDefaults(uiDefaults);
    }

    protected void initSystemColorDefaults(UIDefaults table) {
        String[] defaultSystemColors = new String[]{"desktop", "#005C5C", "activeCaption", "#000080", "activeCaptionText", "#FFFFFF", "activeCaptionBorder", "#C0C0C0", "inactiveCaption", "#808080", "inactiveCaptionText", "#C0C0C0", "inactiveCaptionBorder", "#C0C0C0", "window", "#FFFFFF", "windowBorder", "#000000", "windowText", "#000000", "menu", "#C0C0C0", "menuPressedItemB", "#000080", "menuPressedItemF", "#FFFFFF", "menuText", "#000000", "text", "#C0C0C0", "textText", "#000000", "textHighlight", "#000080", "textHighlightText", "#FFFFFF", "textInactiveText", "#808080", "control", "#C0C0C0", "controlText", "#000000", "controlHighlight", "#C0C0C0", "controlLtHighlight", "#FFFFFF", "controlShadow", "#808080", "controlDkShadow", "#000000", "scrollbar", "#E0E0E0", "info", "#FFFFE1", "infoText", "#000000"};
        this.loadSystemColors(table, defaultSystemColors, this.isNativeLookAndFeel());
    }

    private void initResourceBundle(UIDefaults table) {
        table.addResourceBundle("com.sun.java.swing.plaf.windows.resources.windows");
    }

    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        this.initResourceBundle(table);
        Integer twelve = new Integer(12);
        Integer eight = new Integer(8);
        Integer ten = new Integer(10);
        Integer fontPlain = new Integer(0);
        Integer fontBold = new Integer(1);
        UIDefaults.ProxyLazyValue dialogPlain12 = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{"Dialog", fontPlain, twelve});
        UIDefaults.ProxyLazyValue serifPlain12 = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{"Serif", fontPlain, twelve});
        UIDefaults.ProxyLazyValue sansSerifPlain12 = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{"SansSerif", fontPlain, twelve});
        UIDefaults.ProxyLazyValue monospacedPlain12 = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{"MonoSpaced", fontPlain, twelve});
        UIDefaults.ProxyLazyValue dialogBold12 = new UIDefaults.ProxyLazyValue("javax.swing.plaf.FontUIResource", null, new Object[]{"Dialog", fontBold, twelve});
        ColorUIResource red = new ColorUIResource(Color.red);
        ColorUIResource black = new ColorUIResource(Color.black);
        ColorUIResource white = new ColorUIResource(Color.white);
        ColorUIResource yellow = new ColorUIResource(Color.yellow);
        ColorUIResource gray = new ColorUIResource(Color.gray);
        ColorUIResource lightGray = new ColorUIResource(Color.lightGray);
        ColorUIResource darkGray = new ColorUIResource(Color.darkGray);
        ColorUIResource scrollBarTrack = lightGray;
        ColorUIResource scrollBarTrackHighlight = darkGray;
        String osVersion = System.getProperty("os.version");
        if (osVersion != null) {
            try {
                Float version = Float.valueOf(osVersion);
                isClassicWindows = (double)version.floatValue() <= 4.0;
            }
            catch (NumberFormatException ex) {
                isClassicWindows = false;
            }
        }
        ColorUIResource treeSelection = new ColorUIResource(0, 0, 128);
        Icon treeExpandedIcon = WindowsTreeUI.ExpandedIcon.createExpandedIcon();
        Icon treeCollapsedIcon = WindowsTreeUI.CollapsedIcon.createCollapsedIcon();
        UIDefaults.LazyInputMap fieldInputMap = new UIDefaults.LazyInputMap(new Object[]{"control C", "copy-to-clipboard", "control V", "paste-from-clipboard", "control X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "control INSERT", "copy-to-clipboard", "shift INSERT", "paste-from-clipboard", "shift DELETE", "cut-to-clipboard", "control A", "select-all", "control BACK_SLASH", "unselect", "shift LEFT", "selection-backward", "shift RIGHT", "selection-forward", "control LEFT", "caret-previous-word", "control RIGHT", "caret-next-word", "control shift LEFT", "selection-previous-word", "control shift RIGHT", "selection-next-word", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "typed \b", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "control shift O", "toggle-componentOrientation"});
        UIDefaults.LazyInputMap multilineInputMap = new UIDefaults.LazyInputMap(new Object[]{"control C", "copy-to-clipboard", "control V", "paste-from-clipboard", "control X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "control INSERT", "copy-to-clipboard", "shift INSERT", "paste-from-clipboard", "shift DELETE", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift RIGHT", "selection-forward", "control LEFT", "caret-previous-word", "control RIGHT", "caret-next-word", "control shift LEFT", "selection-previous-word", "control shift RIGHT", "selection-next-word", "control A", "select-all", "control BACK_SLASH", "unselect", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "control HOME", "caret-begin", "control END", "caret-end", "control shift HOME", "selection-begin", "control shift END", "selection-end", "UP", "caret-up", "DOWN", "caret-down", "typed \b", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "PAGE_UP", "page-up", "PAGE_DOWN", "page-down", "shift PAGE_UP", "selection-page-up", "shift PAGE_DOWN", "selection-page-down", "ctrl shift PAGE_UP", "selection-page-left", "ctrl shift PAGE_DOWN", "selection-page-right", "shift UP", "selection-up", "shift DOWN", "selection-down", "ENTER", "insert-break", "TAB", "insert-tab", "control T", "next-link-action", "control shift T", "previous-link-action", "control SPACE", "activate-link-action", "control shift O", "toggle-componentOrientation"});
        DimensionUIResource toolBarSeparatorSize = new DimensionUIResource(6, 20);
        String menuItemAcceleratorDelimiter = new String("+");
        DesktopProperty ControlBackgroundColor = new DesktopProperty("win.3d.backgroundColor", table.get("control"), this.toolkit);
        DesktopProperty ControlLightColor = new DesktopProperty("win.3d.lightColor", table.get("controlHighlight"), this.toolkit);
        DesktopProperty ControlHighlightColor = new DesktopProperty("win.3d.highlightColor", table.get("controlLtHighlight"), this.toolkit);
        DesktopProperty ControlShadowColor = new DesktopProperty("win.3d.shadowColor", table.get("controlShadow"), this.toolkit);
        DesktopProperty ControlDarkShadowColor = new DesktopProperty("win.3d.darkShadowColor", table.get("controlDkShadow"), this.toolkit);
        DesktopProperty ControlTextColor = new DesktopProperty("win.button.textColor", table.get("controlText"), this.toolkit);
        DesktopProperty MenuBackgroundColor = new DesktopProperty("win.menu.backgroundColor", table.get("menu"), this.toolkit);
        DesktopProperty MenuTextColor = new DesktopProperty("win.menu.textColor", table.get("menuText"), this.toolkit);
        DesktopProperty SelectionBackgroundColor = new DesktopProperty("win.item.highlightColor", table.get("textHighlight"), this.toolkit);
        DesktopProperty SelectionTextColor = new DesktopProperty("win.item.highlightTextColor", table.get("textHighlightText"), this.toolkit);
        DesktopProperty WindowBackgroundColor = new DesktopProperty("win.frame.backgroundColor", table.get("window"), this.toolkit);
        DesktopProperty WindowTextColor = new DesktopProperty("win.frame.textColor", table.get("windowText"), this.toolkit);
        DesktopProperty WindowBorderWidth = new DesktopProperty("win.frame.sizingBorderWidth", (Object)new Integer(1), this.toolkit);
        DesktopProperty InactiveTextColor = new DesktopProperty("win.text.grayedTextColor", table.get("textInactiveText"), this.toolkit);
        DesktopProperty ScrollbarBackgroundColor = new DesktopProperty("win.scrollbar.backgroundColor", table.get("scrollbar"), this.toolkit);
        Object MenuFont = dialogPlain12;
        Object FixedControlFont = monospacedPlain12;
        Object ControlFont = dialogPlain12;
        Object MessageFont = dialogPlain12;
        Object WindowFont = dialogBold12;
        Object ToolTipFont = sansSerifPlain12;
        DesktopProperty scrollBarWidth = new DesktopProperty("win.scrollbar.width", (Object)new Integer(16), this.toolkit);
        DesktopProperty showMnemonics = new DesktopProperty("win.menu.keyboardCuesOn", (Object)Boolean.TRUE, this.toolkit);
        if (this.useSystemFontSettings) {
            MenuFont = this.getDesktopFontValue("win.menu.font", MenuFont, this.toolkit);
            FixedControlFont = this.getDesktopFontValue("win.ansi.font", FixedControlFont, this.toolkit);
            ControlFont = this.getDesktopFontValue("win.ansiVar.font", ControlFont, this.toolkit);
            MessageFont = this.getDesktopFontValue("win.messagebox.font", MessageFont, this.toolkit);
            WindowFont = this.getDesktopFontValue("win.frame.captionFont", WindowFont, this.toolkit);
            ToolTipFont = this.getDesktopFontValue("win.tooltip.font", ToolTipFont, this.toolkit);
        }
        if (this.useSystemFontSizeSettings) {
            MenuFont = new WindowsFontProperty("win.menu.font.height", this.toolkit, "Dialog", 0, 12);
            FixedControlFont = new WindowsFontProperty("win.ansi.font.height", this.toolkit, "MonoSpaced", 0, 12);
            ControlFont = new WindowsFontProperty("win.ansiVar.font.height", this.toolkit, "Dialog", 0, 12);
            MessageFont = new WindowsFontProperty("win.messagebox.font.height", this.toolkit, "Dialog", 0, 12);
            WindowFont = new WindowsFontProperty("win.frame.captionFont.height", this.toolkit, "Dialog", 1, 12);
            ToolTipFont = new WindowsFontProperty("win.tooltip.font.height", this.toolkit, "SansSerif", 0, 12);
        }
        Object[] defaults = new Object[]{"AuditoryCues.playList", null, "Application.useSystemFontSettings", this.useSystemFontSettings, "TextField.focusInputMap", fieldInputMap, "PasswordField.focusInputMap", fieldInputMap, "TextArea.focusInputMap", multilineInputMap, "TextPane.focusInputMap", multilineInputMap, "EditorPane.focusInputMap", multilineInputMap, "Button.font", ControlFont, "Button.background", ControlBackgroundColor, "Button.foreground", ControlTextColor, "Button.shadow", ControlShadowColor, "Button.darkShadow", ControlDarkShadowColor, "Button.light", ControlLightColor, "Button.highlight", ControlHighlightColor, "Button.disabledForeground", InactiveTextColor, "Button.disabledShadow", ControlHighlightColor, "Button.focus", black, "Button.dashedRectGapX", new Integer(5), "Button.dashedRectGapY", new Integer(4), "Button.dashedRectGapWidth", new Integer(10), "Button.dashedRectGapHeight", new Integer(8), "Button.textShiftOffset", new Integer(1), "Button.showMnemonics", showMnemonics, "Button.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released"}), "CheckBox.font", ControlFont, "CheckBox.interiorBackground", WindowBackgroundColor, "CheckBox.background", ControlBackgroundColor, "CheckBox.foreground", ControlTextColor, "CheckBox.shadow", ControlShadowColor, "CheckBox.darkShadow", ControlDarkShadowColor, "CheckBox.light", ControlLightColor, "CheckBox.highlight", ControlHighlightColor, "CheckBox.focus", black, "CheckBox.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released"}), "CheckBoxMenuItem.font", MenuFont, "CheckBoxMenuItem.background", MenuBackgroundColor, "CheckBoxMenuItem.foreground", MenuTextColor, "CheckBoxMenuItem.selectionForeground", SelectionTextColor, "CheckBoxMenuItem.selectionBackground", SelectionBackgroundColor, "CheckBoxMenuItem.acceleratorForeground", MenuTextColor, "CheckBoxMenuItem.acceleratorSelectionForeground", SelectionTextColor, "CheckBoxMenuItem.commandSound", "win.sound.menuCommand", "ComboBox.font", ControlFont, "ComboBox.background", WindowBackgroundColor, "ComboBox.foreground", WindowTextColor, "ComboBox.buttonBackground", ControlBackgroundColor, "ComboBox.buttonShadow", ControlShadowColor, "ComboBox.buttonDarkShadow", ControlDarkShadowColor, "ComboBox.buttonHighlight", ControlHighlightColor, "ComboBox.selectionBackground", SelectionBackgroundColor, "ComboBox.selectionForeground", SelectionTextColor, "ComboBox.disabledBackground", ControlBackgroundColor, "ComboBox.disabledForeground", InactiveTextColor, "ComboBox.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "hidePopup", "PAGE_UP", "pageUpPassThrough", "PAGE_DOWN", "pageDownPassThrough", "HOME", "homePassThrough", "END", "endPassThrough", "DOWN", "selectNext", "KP_DOWN", "selectNext", "UP", "selectPrevious", "KP_UP", "selectPrevious", "ENTER", "enterPressed", "F4", "togglePopup"}), "Desktop.background", new DesktopProperty("win.desktop.backgroundColor", table.get("desktop"), this.toolkit), "Desktop.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl F5", "restore", "ctrl F4", "close", "ctrl F7", "move", "ctrl F8", "resize", "RIGHT", "right", "KP_RIGHT", "right", "LEFT", "left", "KP_LEFT", "left", "UP", "up", "KP_UP", "up", "DOWN", "down", "KP_DOWN", "down", "ESCAPE", "escape", "ctrl F9", "minimize", "ctrl F10", "maximize", "ctrl F6", "selectNextFrame", "ctrl TAB", "selectNextFrame", "ctrl alt F6", "selectNextFrame", "shift ctrl alt F6", "selectPreviousFrame", "ctrl F12", "navigateNext", "shift ctrl F12", "navigatePrevious"}), "DesktopIcon.width", new Integer(160), "EditorPane.font", ControlFont, "EditorPane.background", WindowBackgroundColor, "EditorPane.foreground", WindowTextColor, "EditorPane.selectionBackground", SelectionBackgroundColor, "EditorPane.selectionForeground", SelectionTextColor, "EditorPane.caretForeground", WindowTextColor, "EditorPane.inactiveForeground", InactiveTextColor, "FileChooser.homeFolderIcon", new LazyFileChooserIcon(null, "icons/HomeFolder.gif"), "FileChooser.listViewIcon", new LazyFileChooserIcon("fileChooserIcon 2", "icons/ListView.gif"), "FileChooser.detailsViewIcon", new LazyFileChooserIcon("fileChooserIcon 3", "icons/DetailsView.gif"), "FileChooser.upFolderIcon", new LazyFileChooserIcon("fileChooserIcon 8", "icons/UpFolder.gif"), "FileChooser.newFolderIcon", new LazyFileChooserIcon("fileChooserIcon 11", "icons/NewFolder.gif"), "FileChooser.lookInLabelMnemonic", new Integer(73), "FileChooser.fileNameLabelMnemonic", new Integer(78), "FileChooser.filesOfTypeLabelMnemonic", new Integer(84), "FileChooser.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "cancelSelection", "BACK_SPACE", "Go Up", "ENTER", "approveSelection"}), "FileView.directoryIcon", LookAndFeel.makeIcon(this.getClass(), "icons/Directory.gif"), "FileView.fileIcon", LookAndFeel.makeIcon(this.getClass(), "icons/File.gif"), "FileView.computerIcon", LookAndFeel.makeIcon(this.getClass(), "icons/Computer.gif"), "FileView.hardDriveIcon", LookAndFeel.makeIcon(this.getClass(), "icons/HardDrive.gif"), "FileView.floppyDriveIcon", LookAndFeel.makeIcon(this.getClass(), "icons/FloppyDrive.gif"), "InternalFrame.titleFont", WindowFont, "InternalFrame.borderColor", ControlBackgroundColor, "InternalFrame.borderShadow", ControlShadowColor, "InternalFrame.borderDarkShadow", ControlDarkShadowColor, "InternalFrame.borderHighlight", ControlHighlightColor, "InternalFrame.borderLight", ControlLightColor, "InternalFrame.borderWidth", WindowBorderWidth, "InternalFrame.minimizeIconBackground", ControlBackgroundColor, "InternalFrame.resizeIconHighlight", ControlLightColor, "InternalFrame.resizeIconShadow", ControlShadowColor, "InternalFrame.activeBorderColor", new DesktopProperty("win.frame.activeBorderColor", table.get("windowBorder"), this.toolkit), "InternalFrame.inactiveBorderColor", new DesktopProperty("win.frame.inactiveBorderColor", table.get("windowBorder"), this.toolkit), "InternalFrame.activeTitleBackground", new DesktopProperty("win.frame.activeCaptionColor", table.get("activeCaption"), this.toolkit), "InternalFrame.activeTitleGradient", new DesktopProperty("win.frame.activeCaptionGradientColor", table.get("activeCaption"), this.toolkit), "InternalFrame.activeTitleForeground", new DesktopProperty("win.frame.captionTextColor", table.get("activeCaptionText"), this.toolkit), "InternalFrame.inactiveTitleBackground", new DesktopProperty("win.frame.inactiveCaptionColor", table.get("inactiveCaption"), this.toolkit), "InternalFrame.inactiveTitleGradient", new DesktopProperty("win.frame.inactiveCaptionGradientColor", table.get("inactiveCaption"), this.toolkit), "InternalFrame.inactiveTitleForeground", new DesktopProperty("win.frame.inactiveCaptionTextColor", table.get("inactiveCaptionText"), this.toolkit), "InternalFrame.maximizeIcon", WindowsIconFactory.createFrameMaximizeIcon(), "InternalFrame.minimizeIcon", WindowsIconFactory.createFrameMinimizeIcon(), "InternalFrame.iconifyIcon", WindowsIconFactory.createFrameIconifyIcon(), "InternalFrame.closeIcon", WindowsIconFactory.createFrameCloseIcon(), "InternalFrame.closeSound", "win.sound.close", "InternalFrame.maximizeSound", "win.sound.maximize", "InternalFrame.minimizeSound", "win.sound.minimize", "InternalFrame.restoreDownSound", "win.sound.restoreDown", "InternalFrame.restoreUpSound", "win.sound.restoreUp", "InternalFrame.windowBindings", new Object[]{"shift ESCAPE", "showSystemMenu", "ctrl SPACE", "showSystemMenu", "ESCAPE", "hideSystemMenu"}, "Label.font", ControlFont, "Label.background", ControlBackgroundColor, "Label.foreground", ControlTextColor, "Label.disabledForeground", InactiveTextColor, "Label.disabledShadow", ControlHighlightColor, "List.font", ControlFont, "List.background", WindowBackgroundColor, "List.foreground", WindowTextColor, "List.selectionBackground", SelectionBackgroundColor, "List.selectionForeground", SelectionTextColor, "List.focusCellBorderColor", ControlHighlightColor, "List.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy", "ctrl V", "paste", "ctrl X", "cut", "COPY", "copy", "PASTE", "paste", "CUT", "cut", "UP", "selectPreviousRow", "KP_UP", "selectPreviousRow", "shift UP", "selectPreviousRowExtendSelection", "shift KP_UP", "selectPreviousRowExtendSelection", "DOWN", "selectNextRow", "KP_DOWN", "selectNextRow", "shift DOWN", "selectNextRowExtendSelection", "shift KP_DOWN", "selectNextRowExtendSelection", "LEFT", "selectPreviousColumn", "KP_LEFT", "selectPreviousColumn", "shift LEFT", "selectPreviousColumnExtendSelection", "shift KP_LEFT", "selectPreviousColumnExtendSelection", "RIGHT", "selectNextColumn", "KP_RIGHT", "selectNextColumn", "shift RIGHT", "selectNextColumnExtendSelection", "shift KP_RIGHT", "selectNextColumnExtendSelection", "ctrl SPACE", "selectNextRowExtendSelection", "HOME", "selectFirstRow", "shift HOME", "selectFirstRowExtendSelection", "END", "selectLastRow", "shift END", "selectLastRowExtendSelection", "PAGE_UP", "scrollUp", "shift PAGE_UP", "scrollUpExtendSelection", "PAGE_DOWN", "scrollDown", "shift PAGE_DOWN", "scrollDownExtendSelection", "ctrl A", "selectAll", "ctrl SLASH", "selectAll", "ctrl BACK_SLASH", "clearSelection"}), "PopupMenu.font", MenuFont, "PopupMenu.background", MenuBackgroundColor, "PopupMenu.foreground", MenuTextColor, "PopupMenu.popupSound", "win.sound.menuPopup", "Menu.font", MenuFont, "Menu.foreground", MenuTextColor, "Menu.background", MenuBackgroundColor, "Menu.selectionForeground", SelectionTextColor, "Menu.selectionBackground", SelectionBackgroundColor, "Menu.acceleratorForeground", MenuTextColor, "Menu.acceleratorSelectionForeground", SelectionTextColor, "Menu.menuPopupOffsetX", new Integer(0), "Menu.menuPopupOffsetY", new Integer(0), "Menu.submenuPopupOffsetX", new Integer(-4), "Menu.submenuPopupOffsetY", new Integer(-3), "Menu.crossMenuMnemonic", Boolean.FALSE, "MenuBar.font", MenuFont, "MenuBar.background", MenuBackgroundColor, "MenuBar.foreground", MenuTextColor, "MenuBar.shadow", ControlShadowColor, "MenuBar.highlight", ControlHighlightColor, "MenuBar.windowBindings", new Object[]{"F10", "takeFocus"}, "MenuItem.font", MenuFont, "MenuItem.acceleratorFont", MenuFont, "MenuItem.foreground", MenuTextColor, "MenuItem.background", MenuBackgroundColor, "MenuItem.selectionForeground", SelectionTextColor, "MenuItem.selectionBackground", SelectionBackgroundColor, "MenuItem.disabledForeground", InactiveTextColor, "MenuItem.acceleratorForeground", MenuTextColor, "MenuItem.acceleratorSelectionForeground", SelectionTextColor, "MenuItem.acceleratorDelimiter", menuItemAcceleratorDelimiter, "MenuItem.commandSound", "win.sound.menuCommand", "RadioButton.font", ControlFont, "RadioButton.interiorBackground", WindowBackgroundColor, "RadioButton.background", ControlBackgroundColor, "RadioButton.foreground", ControlTextColor, "RadioButton.shadow", ControlShadowColor, "RadioButton.darkShadow", ControlDarkShadowColor, "RadioButton.light", ControlLightColor, "RadioButton.highlight", ControlHighlightColor, "RadioButton.focus", black, "RadioButton.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released"}), "RadioButtonMenuItem.font", MenuFont, "RadioButtonMenuItem.foreground", MenuTextColor, "RadioButtonMenuItem.background", MenuBackgroundColor, "RadioButtonMenuItem.selectionForeground", SelectionTextColor, "RadioButtonMenuItem.selectionBackground", SelectionBackgroundColor, "RadioButtonMenuItem.disabledForeground", InactiveTextColor, "RadioButtonMenuItem.acceleratorForeground", MenuTextColor, "RadioButtonMenuItem.acceleratorSelectionForeground", SelectionTextColor, "RadioButtonMenuItem.commandSound", "win.sound.menuCommand", "OptionPane.font", MessageFont, "OptionPane.messageFont", MessageFont, "OptionPane.buttonFont", MessageFont, "OptionPane.background", ControlBackgroundColor, "OptionPane.foreground", ControlTextColor, "OptionPane.messageForeground", ControlTextColor, "OptionPane.windowBindings", new Object[]{"ESCAPE", "close"}, "OptionPane.errorSound", "win.sound.hand", "OptionPane.informationSound", "win.sound.asterisk", "OptionPane.questionSound", "win.sound.question", "OptionPane.warningSound", "win.sound.exclamation", "FormattedTextField.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "typed \b", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "ctrl BACK_SLASH", "unselect", "control shift O", "toggle-componentOrientation", "ESCAPE", "reset-field-edit", "UP", "increment", "KP_UP", "increment", "DOWN", "decrement", "KP_DOWN", "decrement"}), "Panel.font", ControlFont, "Panel.background", ControlBackgroundColor, "Panel.foreground", WindowTextColor, "PasswordField.font", FixedControlFont, "PasswordField.background", WindowBackgroundColor, "PasswordField.foreground", WindowTextColor, "PasswordField.inactiveForeground", InactiveTextColor, "PasswordField.inactiveBackground", ControlBackgroundColor, "PasswordField.selectionBackground", SelectionBackgroundColor, "PasswordField.selectionForeground", SelectionTextColor, "PasswordField.caretForeground", WindowTextColor, "ProgressBar.font", ControlFont, "ProgressBar.foreground", SelectionBackgroundColor, "ProgressBar.background", ControlBackgroundColor, "ProgressBar.shadow", ControlShadowColor, "ProgressBar.highlight", ControlHighlightColor, "ProgressBar.selectionForeground", ControlBackgroundColor, "ProgressBar.selectionBackground", SelectionBackgroundColor, "ProgressBar.cellLength", new Integer(7), "ProgressBar.cellSpacing", new Integer(2), "RootPane.defaultButtonWindowKeyBindings", new Object[]{"ENTER", "press", "released ENTER", "release", "ctrl ENTER", "press", "ctrl released ENTER", "release"}, "ScrollBar.background", ScrollbarBackgroundColor, "ScrollBar.foreground", ControlBackgroundColor, "ScrollBar.track", white, "ScrollBar.trackForeground", ScrollbarBackgroundColor, "ScrollBar.trackHighlight", black, "ScrollBar.trackHighlightForeground", scrollBarTrackHighlight, "ScrollBar.thumb", ControlBackgroundColor, "ScrollBar.thumbHighlight", ControlHighlightColor, "ScrollBar.thumbDarkShadow", ControlDarkShadowColor, "ScrollBar.thumbShadow", ControlShadowColor, "ScrollBar.width", scrollBarWidth, "ScrollBar.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "positiveUnitIncrement", "KP_RIGHT", "positiveUnitIncrement", "DOWN", "positiveUnitIncrement", "KP_DOWN", "positiveUnitIncrement", "PAGE_DOWN", "positiveBlockIncrement", "ctrl PAGE_DOWN", "positiveBlockIncrement", "LEFT", "negativeUnitIncrement", "KP_LEFT", "negativeUnitIncrement", "UP", "negativeUnitIncrement", "KP_UP", "negativeUnitIncrement", "PAGE_UP", "negativeBlockIncrement", "ctrl PAGE_UP", "negativeBlockIncrement", "HOME", "minScroll", "END", "maxScroll"}), "ScrollPane.font", ControlFont, "ScrollPane.background", ControlBackgroundColor, "ScrollPane.foreground", ControlTextColor, "ScrollPane.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "unitScrollRight", "KP_RIGHT", "unitScrollRight", "DOWN", "unitScrollDown", "KP_DOWN", "unitScrollDown", "LEFT", "unitScrollLeft", "KP_LEFT", "unitScrollLeft", "UP", "unitScrollUp", "KP_UP", "unitScrollUp", "PAGE_UP", "scrollUp", "PAGE_DOWN", "scrollDown", "ctrl PAGE_UP", "scrollLeft", "ctrl PAGE_DOWN", "scrollRight", "ctrl HOME", "scrollHome", "ctrl END", "scrollEnd"}), "Separator.background", ControlHighlightColor, "Separator.foreground", ControlShadowColor, "Slider.foreground", ControlBackgroundColor, "Slider.background", ControlBackgroundColor, "Slider.highlight", ControlHighlightColor, "Slider.shadow", ControlShadowColor, "Slider.focus", ControlDarkShadowColor, "Slider.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "positiveUnitIncrement", "KP_RIGHT", "positiveUnitIncrement", "DOWN", "negativeUnitIncrement", "KP_DOWN", "negativeUnitIncrement", "PAGE_DOWN", "negativeBlockIncrement", "LEFT", "negativeUnitIncrement", "KP_LEFT", "negativeUnitIncrement", "UP", "positiveUnitIncrement", "KP_UP", "positiveUnitIncrement", "PAGE_UP", "positiveBlockIncrement", "HOME", "minScroll", "END", "maxScroll"}), "Spinner.font", FixedControlFont, "Spinner.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"UP", "increment", "KP_UP", "increment", "DOWN", "decrement", "KP_DOWN", "decrement"}), "SplitPane.background", ControlBackgroundColor, "SplitPane.highlight", ControlLightColor, "SplitPane.shadow", ControlShadowColor, "SplitPane.darkShadow", ControlDarkShadowColor, "SplitPane.dividerSize", new Integer(5), "SplitPane.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"UP", "negativeIncrement", "DOWN", "positiveIncrement", "LEFT", "negativeIncrement", "RIGHT", "positiveIncrement", "KP_UP", "negativeIncrement", "KP_DOWN", "positiveIncrement", "KP_LEFT", "negativeIncrement", "KP_RIGHT", "positiveIncrement", "HOME", "selectMin", "END", "selectMax", "F8", "startResize", "F6", "toggleFocus", "ctrl TAB", "focusOutForward", "ctrl shift TAB", "focusOutBackward"}), "TabbedPane.font", ControlFont, "TabbedPane.background", ControlBackgroundColor, "TabbedPane.foreground", ControlTextColor, "TabbedPane.highlight", ControlHighlightColor, "TabbedPane.light", ControlLightColor, "TabbedPane.shadow", ControlShadowColor, "TabbedPane.darkShadow", ControlDarkShadowColor, "TabbedPane.focus", ControlTextColor, "TabbedPane.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "navigateRight", "KP_RIGHT", "navigateRight", "LEFT", "navigateLeft", "KP_LEFT", "navigateLeft", "UP", "navigateUp", "KP_UP", "navigateUp", "DOWN", "navigateDown", "KP_DOWN", "navigateDown", "ctrl DOWN", "requestFocusForVisibleComponent", "ctrl KP_DOWN", "requestFocusForVisibleComponent"}), "TabbedPane.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl PAGE_DOWN", "navigatePageDown", "ctrl PAGE_UP", "navigatePageUp", "ctrl UP", "requestFocus", "ctrl KP_UP", "requestFocus"}), "Table.font", ControlFont, "Table.foreground", ControlTextColor, "Table.background", WindowBackgroundColor, "Table.highlight", ControlHighlightColor, "Table.light", ControlLightColor, "Table.shadow", ControlShadowColor, "Table.darkShadow", ControlDarkShadowColor, "Table.selectionForeground", SelectionTextColor, "Table.selectionBackground", SelectionBackgroundColor, "Table.gridColor", gray, "Table.focusCellBackground", WindowBackgroundColor, "Table.focusCellForeground", ControlTextColor, "Table.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy", "ctrl V", "paste", "ctrl X", "cut", "COPY", "copy", "PASTE", "paste", "CUT", "cut", "RIGHT", "selectNextColumn", "KP_RIGHT", "selectNextColumn", "LEFT", "selectPreviousColumn", "KP_LEFT", "selectPreviousColumn", "DOWN", "selectNextRow", "KP_DOWN", "selectNextRow", "UP", "selectPreviousRow", "KP_UP", "selectPreviousRow", "shift RIGHT", "selectNextColumnExtendSelection", "shift KP_RIGHT", "selectNextColumnExtendSelection", "shift LEFT", "selectPreviousColumnExtendSelection", "shift KP_LEFT", "selectPreviousColumnExtendSelection", "shift DOWN", "selectNextRowExtendSelection", "shift KP_DOWN", "selectNextRowExtendSelection", "shift UP", "selectPreviousRowExtendSelection", "shift KP_UP", "selectPreviousRowExtendSelection", "PAGE_UP", "scrollUpChangeSelection", "PAGE_DOWN", "scrollDownChangeSelection", "HOME", "selectFirstColumn", "END", "selectLastColumn", "shift PAGE_UP", "scrollUpExtendSelection", "shift PAGE_DOWN", "scrollDownExtendSelection", "shift HOME", "selectFirstColumnExtendSelection", "shift END", "selectLastColumnExtendSelection", "ctrl PAGE_UP", "scrollLeftChangeSelection", "ctrl PAGE_DOWN", "scrollRightChangeSelection", "ctrl HOME", "selectFirstRow", "ctrl END", "selectLastRow", "ctrl shift PAGE_UP", "scrollRightExtendSelection", "ctrl shift PAGE_DOWN", "scrollLeftExtendSelection", "ctrl shift HOME", "selectFirstRowExtendSelection", "ctrl shift END", "selectLastRowExtendSelection", "TAB", "selectNextColumnCell", "shift TAB", "selectPreviousColumnCell", "ENTER", "selectNextRowCell", "shift ENTER", "selectPreviousRowCell", "ctrl A", "selectAll", "ESCAPE", "cancel", "F2", "startEditing"}), "TableHeader.font", ControlFont, "TableHeader.foreground", ControlTextColor, "TableHeader.background", ControlBackgroundColor, "TextArea.font", FixedControlFont, "TextArea.background", WindowBackgroundColor, "TextArea.foreground", WindowTextColor, "TextArea.inactiveForeground", InactiveTextColor, "TextArea.selectionBackground", SelectionBackgroundColor, "TextArea.selectionForeground", SelectionTextColor, "TextArea.caretForeground", WindowTextColor, "TextField.font", ControlFont, "TextField.background", WindowBackgroundColor, "TextField.foreground", WindowTextColor, "TextField.shadow", ControlShadowColor, "TextField.darkShadow", ControlDarkShadowColor, "TextField.light", ControlLightColor, "TextField.highlight", ControlHighlightColor, "TextField.inactiveForeground", InactiveTextColor, "TextField.inactiveBackground", ControlBackgroundColor, "TextField.selectionBackground", SelectionBackgroundColor, "TextField.selectionForeground", SelectionTextColor, "TextField.caretForeground", WindowTextColor, "TextField.margin", new InsetsUIResource(1, 1, 1, 1), "TextPane.font", ControlFont, "TextPane.background", WindowBackgroundColor, "TextPane.foreground", WindowTextColor, "TextPane.selectionBackground", SelectionBackgroundColor, "TextPane.selectionForeground", SelectionTextColor, "TextPane.caretForeground", WindowTextColor, "TitledBorder.font", ControlFont, "TitledBorder.titleColor", ControlTextColor, "ToggleButton.font", ControlFont, "ToggleButton.background", ControlBackgroundColor, "ToggleButton.foreground", ControlTextColor, "ToggleButton.shadow", ControlShadowColor, "ToggleButton.darkShadow", ControlDarkShadowColor, "ToggleButton.light", ControlLightColor, "ToggleButton.highlight", ControlHighlightColor, "ToggleButton.focus", ControlTextColor, "ToggleButton.textShiftOffset", new Integer(1), "ToggleButton.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released"}), "ToolBar.font", MenuFont, "ToolBar.background", ControlBackgroundColor, "ToolBar.foreground", ControlTextColor, "ToolBar.shadow", ControlShadowColor, "ToolBar.darkShadow", ControlDarkShadowColor, "ToolBar.light", ControlLightColor, "ToolBar.highlight", ControlHighlightColor, "ToolBar.dockingBackground", ControlBackgroundColor, "ToolBar.dockingForeground", red, "ToolBar.floatingBackground", ControlBackgroundColor, "ToolBar.floatingForeground", darkGray, "ToolBar.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"UP", "navigateUp", "KP_UP", "navigateUp", "DOWN", "navigateDown", "KP_DOWN", "navigateDown", "LEFT", "navigateLeft", "KP_LEFT", "navigateLeft", "RIGHT", "navigateRight", "KP_RIGHT", "navigateRight"}), "ToolBar.separatorSize", toolBarSeparatorSize, "ToolTip.font", ToolTipFont, "ToolTip.background", new DesktopProperty("win.tooltip.backgroundColor", table.get("info"), this.toolkit), "ToolTip.foreground", new DesktopProperty("win.tooltip.textColor", table.get("infoText"), this.toolkit), "Tree.font", ControlFont, "Tree.background", WindowBackgroundColor, "Tree.foreground", WindowTextColor, "Tree.hash", gray, "Tree.textForeground", WindowTextColor, "Tree.textBackground", WindowBackgroundColor, "Tree.selectionForeground", SelectionTextColor, "Tree.selectionBackground", SelectionBackgroundColor, "Tree.selectionBorderColor", yellow, "Tree.expandedIcon", treeExpandedIcon, "Tree.collapsedIcon", treeCollapsedIcon, "Tree.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy", "ctrl V", "paste", "ctrl X", "cut", "COPY", "copy", "PASTE", "paste", "CUT", "cut", "UP", "selectPrevious", "KP_UP", "selectPrevious", "shift UP", "selectPreviousExtendSelection", "shift KP_UP", "selectPreviousExtendSelection", "DOWN", "selectNext", "KP_DOWN", "selectNext", "shift DOWN", "selectNextExtendSelection", "shift KP_DOWN", "selectNextExtendSelection", "RIGHT", "selectChild", "KP_RIGHT", "selectChild", "LEFT", "selectParent", "KP_LEFT", "selectParent", "PAGE_UP", "scrollUpChangeSelection", "shift PAGE_UP", "scrollUpExtendSelection", "PAGE_DOWN", "scrollDownChangeSelection", "shift PAGE_DOWN", "scrollDownExtendSelection", "HOME", "selectFirst", "shift HOME", "selectFirstExtendSelection", "END", "selectLast", "shift END", "selectLastExtendSelection", "F2", "startEditing", "ctrl A", "selectAll", "ctrl SLASH", "selectAll", "ctrl BACK_SLASH", "clearSelection", "ctrl SPACE", "toggleSelectionPreserveAnchor", "shift SPACE", "extendSelection", "ctrl HOME", "selectFirstChangeLead", "ctrl END", "selectLastChangeLead", "ctrl UP", "selectPreviousChangeLead", "ctrl KP_UP", "selectPreviousChangeLead", "ctrl DOWN", "selectNextChangeLead", "ctrl KP_DOWN", "selectNextChangeLead", "ctrl PAGE_DOWN", "scrollDownChangeLead", "ctrl shift PAGE_DOWN", "scrollDownExtendSelection", "ctrl PAGE_UP", "scrollUpChangeLead", "ctrl shift PAGE_UP", "scrollUpExtendSelection", "ctrl LEFT", "scrollLeft", "ctrl KP_LEFT", "scrollLeft", "ctrl RIGHT", "scrollRight", "ctrl KP_RIGHT", "scrollRight", "SPACE", "toggleSelectionPreserveAnchor"}), "Tree.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "cancel"}), "Viewport.font", ControlFont, "Viewport.background", ControlBackgroundColor, "Viewport.foreground", WindowTextColor};
        table.putDefaults(defaults);
        table.putDefaults(this.getLazyValueDefaults());
    }

    private Object getDesktopFontValue(String fontName, Object backup, Toolkit kit) {
        if (this.useSystemFontSettings) {
            DesktopProperty prop = new DesktopProperty(fontName, backup, kit);
            Font font = (Font)prop.createValue(null);
            if (!SunGraphicsEnvironment.isLogicalFont((Font)font) && !SunGraphicsEnvironment.fontSupportsDefaultEncoding((Font)font)) {
                this.useSystemFontSettings = false;
                this.useSystemFontSizeSettings = true;
                return null;
            }
            return prop;
        }
        return null;
    }

    private Object[] getLazyValueDefaults() {
        UIDefaults.ProxyLazyValue buttonBorder = new UIDefaults.ProxyLazyValue("javax.swing.plaf.basic.BasicBorders", "getButtonBorder");
        UIDefaults.ProxyLazyValue comboBoxBorder = new UIDefaults.ProxyLazyValue("javax.swing.plaf.basic.BasicBorders", "getTextFieldBorder");
        UIDefaults.ProxyLazyValue focusCellHighlightBorder = new UIDefaults.ProxyLazyValue("com.sun.java.swing.plaf.windows.WindowsBorders", "getFocusCellHighlightBorder");
        UIDefaults.ProxyLazyValue etchedBorder = new UIDefaults.ProxyLazyValue("javax.swing.plaf.BorderUIResource", "getEtchedBorderUIResource");
        UIDefaults.ProxyLazyValue internalFrameBorder = new UIDefaults.ProxyLazyValue("com.sun.java.swing.plaf.windows.WindowsBorders", "getInternalFrameBorder");
        UIDefaults.ProxyLazyValue loweredBevelBorder = new UIDefaults.ProxyLazyValue("javax.swing.plaf.BorderUIResource", "getLoweredBevelBorderUIResource");
        UIDefaults.ProxyLazyValue marginBorder = new UIDefaults.ProxyLazyValue("javax.swing.plaf.basic.BasicBorders$MarginBorder");
        UIDefaults.ProxyLazyValue menuBarBorder = new UIDefaults.ProxyLazyValue("javax.swing.plaf.basic.BasicBorders", "getMenuBarBorder");
        UIDefaults.ProxyLazyValue popupMenuBorder = new UIDefaults.ProxyLazyValue("javax.swing.plaf.basic.BasicBorders", "getInternalFrameBorder");
        UIDefaults.ProxyLazyValue progressBarBorder = new UIDefaults.ProxyLazyValue("com.sun.java.swing.plaf.windows.WindowsBorders", "getProgressBarBorder");
        UIDefaults.ProxyLazyValue radioButtonBorder = new UIDefaults.ProxyLazyValue("javax.swing.plaf.basic.BasicBorders", "getRadioButtonBorder");
        UIDefaults.ProxyLazyValue tableHeaderBorder = new UIDefaults.ProxyLazyValue("com.sun.java.swing.plaf.windows.WindowsBorders", "getTableHeaderBorder");
        UIDefaults.ProxyLazyValue toolBarBorder = new UIDefaults.ProxyLazyValue("com.sun.java.swing.plaf.windows.WindowsBorders", "getToolBarBorder");
        UIDefaults.ProxyLazyValue toolTipBorder = new UIDefaults.ProxyLazyValue("javax.swing.plaf.BorderUIResource", "getBlackLineBorderUIResource");
        UIDefaults.ProxyLazyValue checkBoxIcon = new UIDefaults.ProxyLazyValue("com.sun.java.swing.plaf.windows.WindowsIconFactory", "getCheckBoxIcon");
        UIDefaults.ProxyLazyValue radioButtonIcon = new UIDefaults.ProxyLazyValue("com.sun.java.swing.plaf.windows.WindowsIconFactory", "getRadioButtonIcon");
        UIDefaults.ProxyLazyValue menuItemCheckIcon = new UIDefaults.ProxyLazyValue("com.sun.java.swing.plaf.windows.WindowsIconFactory", "getMenuItemCheckIcon");
        UIDefaults.ProxyLazyValue menuItemArrowIcon = new UIDefaults.ProxyLazyValue("com.sun.java.swing.plaf.windows.WindowsIconFactory", "getMenuItemArrowIcon");
        UIDefaults.ProxyLazyValue menuArrowIcon = new UIDefaults.ProxyLazyValue("com.sun.java.swing.plaf.windows.WindowsIconFactory", "getMenuArrowIcon");
        Object[] lazyDefaults = new Object[]{"Button.border", buttonBorder, "CheckBox.border", radioButtonBorder, "ComboBox.border", comboBoxBorder, "DesktopIcon.border", internalFrameBorder, "InternalFrame.border", internalFrameBorder, "List.focusCellHighlightBorder", focusCellHighlightBorder, "Menu.border", marginBorder, "MenuBar.border", menuBarBorder, "MenuItem.border", marginBorder, "PopupMenu.border", popupMenuBorder, "ProgressBar.border", progressBarBorder, "RadioButton.border", radioButtonBorder, "Spinner.border", loweredBevelBorder, "Table.scrollPaneBorder", loweredBevelBorder, "TableHeader.cellBorder", tableHeaderBorder, "TitledBorder.border", etchedBorder, "ToggleButton.border", radioButtonBorder, "ToolBar.border", toolBarBorder, "ToolTip.border", toolTipBorder, "CheckBox.icon", checkBoxIcon, "Menu.arrowIcon", menuArrowIcon, "MenuItem.checkIcon", menuItemCheckIcon, "MenuItem.arrowIcon", menuItemArrowIcon, "RadioButton.icon", radioButtonIcon};
        return lazyDefaults;
    }

    public void uninitialize() {
        this.toolkit = null;
        if (!isClassicWindows) {
            PopupFactory.setSharedInstance(new PopupFactory());
        }
        if (WindowsPopupMenuUI.mnemonicListener != null) {
            MenuSelectionManager.defaultManager().removeChangeListener((ChangeListener)WindowsPopupMenuUI.mnemonicListener);
        }
        if (WindowsPopupMenuUI.altProcessor != null) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventPostProcessor(WindowsPopupMenuUI.altProcessor);
        }
    }

    public static void setMnemonicHidden(boolean hide) {
        isMnemonicHidden = UIManager.getBoolean("Button.showMnemonics") ? false : hide;
    }

    public static boolean isMnemonicHidden() {
        if (UIManager.getBoolean("Button.showMnemonics")) {
            isMnemonicHidden = false;
        }
        return isMnemonicHidden;
    }

    public static boolean isClassicWindows() {
        return isClassicWindows;
    }

    public void provideErrorFeedback(Component component) {
        super.provideErrorFeedback(component);
    }

    protected Action createAudioAction(Object key) {
        if (key != null) {
            String audioKey = (String)key;
            String audioValue = (String)UIManager.get(key);
            return new AudioAction(audioKey, audioValue);
        }
        return null;
    }

    static void repaintRootPane(Component c) {
        Component root = null;
        while (c != null) {
            if (c instanceof JRootPane) {
                root = (JRootPane)c;
            }
            c = c.getParent();
        }
        if (root != null) {
            root.repaint();
        } else {
            c.repaint();
        }
    }

    private static class WindowsFontProperty
    extends DesktopProperty {
        private String fontName;
        private int fontSize;
        private int fontStyle;

        WindowsFontProperty(String key, Toolkit toolkit, String fontName, int fontStyle, int fontSize) {
            super(key, null, toolkit);
            this.fontName = fontName;
            this.fontSize = fontSize;
            this.fontStyle = fontStyle;
        }

        protected Object configureValue(Object value) {
            if (value == null) {
                value = new FontUIResource(this.fontName, this.fontStyle, this.fontSize);
            } else if (value instanceof Integer) {
                value = new FontUIResource(this.fontName, this.fontStyle, (Integer)value);
            }
            return value;
        }
    }

    private static class LazyFileChooserIcon
    implements UIDefaults.LazyValue {
        private String nativeImage;
        private String resource;

        LazyFileChooserIcon(String nativeImage, String resource) {
            this.nativeImage = nativeImage;
            this.resource = resource;
        }

        public Object createValue(UIDefaults table) {
            if (this.nativeImage != null) {
                Image image = (Image)ShellFolder.get(this.nativeImage);
                return image != null ? new ImageIcon(image) : LookAndFeel.makeIcon(this.getClass(), this.resource);
            }
            return LookAndFeel.makeIcon(this.getClass(), this.resource);
        }
    }

    private static class AudioAction
    extends AbstractAction {
        private Runnable audioRunnable;
        private String audioResource;

        public AudioAction(String name, String resource) {
            super(name);
            this.audioResource = resource;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.audioRunnable == null) {
                this.audioRunnable = (Runnable)Toolkit.getDefaultToolkit().getDesktopProperty(this.audioResource);
            }
            if (this.audioRunnable != null) {
                new Thread(this.audioRunnable).start();
            }
        }
    }
}

