/*
 * Decompiled with CFR 0.152.
 */
package com.stattmann.swing.util;

import com.stattmann.swing.util.GridBagHelper;
import com.stattmann.swing.util.UIHelper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

class AbstractDialog
extends JDialog {
    MouseListener mouseListener = new PopupRequester();

    AbstractDialog(Frame owner, String title, boolean modal) {
        super(owner, title, modal);
    }

    void addSimpleDialog(JComponent c) {
        c.addMouseListener(this.mouseListener);
    }

    void removeSimpleDialog(JComponent c) {
        c.removeMouseListener(this.mouseListener);
    }

    String append(String base, String append) {
        return base + append;
    }

    String center(String center, String base) {
        int diff = base.length() - center.length();
        if (diff < 2) {
            return center;
        }
        StringBuffer buffer = new StringBuffer(center);
        for (int i = 0; i < diff / 2; ++i) {
            buffer.insert(0, " ");
        }
        return buffer.toString();
    }

    public static void open(final Dialog dialog) {
        if (!EventQueue.isDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    AbstractDialog.openDialog(dialog);
                }
            });
        } else {
            AbstractDialog.openDialog(dialog);
        }
    }

    private static void openDialog(Dialog dialog) {
        dialog.setVisible(true);
        dialog.requestFocus();
        UIHelper.bringWindowsToFront();
    }

    public static void centerComponent(Component component) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension componentSize = component.getSize();
        int x = (screenSize.width - componentSize.width) / 2;
        int y = (screenSize.height - componentSize.height) / 2;
        component.setLocation(x, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void validateAll(Component c) {
        if (c != null) {
            Object object = c.getTreeLock();
            synchronized (object) {
                for (Container p = c.getParent(); p != null && !p.isValid(); p = p.getParent()) {
                    c = p;
                    c.validate();
                }
                c.validate();
            }
        }
    }

    class Disposer
    implements ActionListener {
        Disposer() {
        }

        public void actionPerformed(ActionEvent e) {
            AbstractDialog.this.dispose();
        }
    }

    class PopupRequester
    extends MouseAdapter {
        PopupRequester() {
        }

        public void mouseClicked(MouseEvent e) {
            SimpleDialog dialog = new SimpleDialog();
            dialog.pack();
            AbstractDialog.centerComponent(dialog);
            dialog.setResizable(false);
            AbstractDialog.open(dialog);
        }
    }

    class SimpleDialog
    extends JDialog {
        SimpleDialog() {
            super((Frame)null, "EditorTitle", true);
            this.setDefaultCloseOperation(2);
            GridBagLayout gridBag = new GridBagLayout();
            Color foreground = UIManager.getColor("CoreMedia.foreground");
            Color background = UIManager.getColor("CoreMedia.background");
            Container pane = this.getContentPane();
            pane.setLayout(gridBag);
            pane.setBackground(background);
            Icon logo = null;
            JLabel logoImage = new JLabel(this, logo){
                private final /* synthetic */ SimpleDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public boolean isFocusTraversable() {
                    return false;
                }
            };
            GridBagHelper.constrain(pane, logoImage, 0, 0, 1, 1, 0, 11, 0.0, 0.0, 8, 8, 12, 8);
            JTextArea version = new JTextArea(this, "version"){
                private final /* synthetic */ SimpleDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public boolean isFocusTraversable() {
                    return false;
                }
            };
            version.setBackground(background);
            version.setForeground(foreground);
            GridBagHelper.constrain(pane, version, 0, 1, 1, 1, 0, 10, 0.0, 0.0, 0, 8, 16, 8);
            JTextArea license = new JTextArea(this, "license"){
                private final /* synthetic */ SimpleDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public boolean isFocusTraversable() {
                    return false;
                }
            };
            license.setForeground(foreground);
            license.setBackground(background);
            GridBagHelper.constrain(pane, license, 0, 2, 1, 1, 10, 17, 0.0, 0.0, 0, 8, 8, 8);
            JButton okayButton = new JButton("info-editor-okay-button");
            okayButton.addActionListener(new ActionListener(this, AbstractDialog.this){
                private final /* synthetic */ AbstractDialog val$this$0;
                private final /* synthetic */ SimpleDialog this$1;
                {
                    this.this$1 = this$1;
                    this.val$this$0 = val$this$0;
                }

                public void actionPerformed(ActionEvent e) {
                    this.this$1.dispose();
                }
            });
            GridBagHelper.constrain(pane, okayButton, 0, 5, 1, 1, 0, 10, 0.0, 0.0, 16, 8, 8, 8);
            this.getRootPane().setDefaultButton(okayButton);
        }
    }
}

