/*
 * Decompiled with CFR 0.152.
 */
package com.stattmann.swing.manager;

import com.stattmann.swing.command.Command;
import com.stattmann.swing.manager.CommandManager;
import com.stattmann.swing.manager.FocusManager;
import com.stattmann.swing.manager.FocusManagerImpl;
import java.awt.AWTEvent;
import java.awt.Component;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CommandManagerImpl
implements CommandManager {
    private static CommandManager ourInstance = new CommandManagerImpl();
    private Map commandRegistry;
    private FocusManager focusManager = FocusManagerImpl.getInstance();
    private boolean debug = true;
    private static final Log log = LogFactory.getLog((Class)(class$com$stattmann$swing$manager$CommandManager == null ? (class$com$stattmann$swing$manager$CommandManager = CommandManagerImpl.class$("com.stattmann.swing.manager.CommandManager")) : class$com$stattmann$swing$manager$CommandManager));
    static /* synthetic */ Class class$com$stattmann$swing$manager$CommandManager;

    public static CommandManager getInstance() {
        return ourInstance;
    }

    private CommandManagerImpl() {
        this.commandRegistry = new Hashtable();
    }

    public void registerCommand(Command command) {
        Command oldCommand;
        if (command != null && (oldCommand = this.commandRegistry.put(command.getName(), command)) != null) {
            log.warn((Object)("Overwriting command " + oldCommand.getClass().getName() + " registered as " + command.getName() + " with " + command.getClass().getName()));
        }
    }

    public void executeCommands(String name, AWTEvent sourceEvent) {
        Component focusedComponent = this.focusManager.getFocusedComponent();
        Command command = (Command)this.commandRegistry.get(name);
        if (command != null) {
            command.execute(sourceEvent, focusedComponent);
        }
    }

    public void setDebug(boolean value) {
        this.debug = value;
    }

    static Log getLog() {
        return log;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

