/*
 * Decompiled with CFR 0.152.
 */
package com.stattmann.swing.util;

import com.stattmann.swing.util.Pair;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;

public class TestLookAndFeel
extends WindowsLookAndFeel {
    private HashMap systemDefaults = new HashMap(1);
    private HashMap componentDefaults = new HashMap(1);

    public TestLookAndFeel() {
        try {
            UIManager.put("OptionPane.yesButtonText", "yes-button-text");
            UIManager.put("OptionPane.noButtonText", "no-button-text");
            UIManager.put("OptionPane.okButtonText", "ok-button-text");
            UIManager.put("OptionPane.cancelButtonText", "cancel-button-text");
        }
        catch (Exception e) {
            System.out.println("Cannot initialize option pane localization: " + e);
        }
    }

    public Object createSystemColor(Map attributes, Object parent) throws Exception {
        if (!(parent instanceof TestLookAndFeel)) {
            throw new Exception("May only have <SystemColor> in <LookAndFeel class=\"hox.corem.editor.toolkit.plaf.CoreMediaLookAndFeel\">");
        }
        String name = (String)attributes.get("name");
        attributes.remove("name");
        String value = (String)attributes.get("value");
        attributes.remove("value");
        return new Pair(name, value);
    }

    public Object createComponentColor(Map attributes, Object parent) throws Exception {
        if (!(parent instanceof TestLookAndFeel)) {
            throw new Exception("May only have <ComponentColor> in <LookAndFeel class=\"hox.corem.editor.toolkit.plaf.CoreMediaLookAndFeel\">");
        }
        String name = (String)attributes.get("name");
        attributes.remove("name");
        String value = (String)attributes.get("value");
        attributes.remove("value");
        return new Pair(name, value);
    }

    public void addSystemColor(Pair pair) {
        this.systemDefaults.put(pair.first, pair.second);
    }

    public void addComponentColor(Pair pair) {
        Color color = Color.decode(pair.second.toString());
        this.addComponentColor(pair.first.toString(), new ColorUIResource(color));
    }

    void addComponentColor(String name, ColorUIResource value) {
        this.componentDefaults.put(name, value);
    }

    void addComponentColor(String name, Object value) {
        this.componentDefaults.put(name, value);
    }

    void addCoreMediaDefault(String name, String value) {
        if (!this.systemDefaults.containsKey(name)) {
            this.addSystemColor(new Pair(name, value));
        }
    }

    void addCoreMediaDefault(String name, ColorUIResource value) {
        if (!this.componentDefaults.containsKey(name)) {
            this.addComponentColor(name, value);
        }
    }

    void addCoreMediaDefault(String name, Object value) {
        if (!this.componentDefaults.containsKey(name)) {
            this.addComponentColor(name, value);
        }
    }

    String[] convertToSystemColorArray(HashMap map) {
        String[] array = new String[map.size() * 2];
        int count = 0;
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next().toString();
            String value = map.get(key).toString();
            array[count++] = key;
            array[count++] = value;
        }
        return array;
    }

    Object[] convertToComponentArray(HashMap map) {
        Object[] array = new Object[map.size() * 2];
        int count = 0;
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            Object value = map.get(key);
            array[count++] = key;
            array[count++] = value;
        }
        return array;
    }

    protected void initSystemColorDefaults(UIDefaults table) {
        super.initSystemColorDefaults(table);
        this.loadSystemColors(table, this.convertToSystemColorArray(this.systemDefaults), this.isNativeLookAndFeel());
    }

    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        this.addCoreMediaDefault("CoreMedia.foreground", new ColorUIResource(255, 255, 255));
        this.addCoreMediaDefault("CoreMedia.background", new ColorUIResource(69, 84, 91));
        table.putDefaults(this.convertToComponentArray(this.componentDefaults));
    }

    public String getID() {
        return "CoreMedia";
    }

    public String getDescription() {
        return "CoreMedia Look and Feel";
    }

    public boolean isSupportedLookAndFeel() {
        return true;
    }

    public void initialize() {
        if (!super.isNativeLookAndFeel()) {
            String osVersion = System.getProperty("os.version");
            System.setProperty("os.version", "5.0");
            super.initialize();
            System.setProperty("os.version", osVersion);
        }
    }
}

