--------------------------------------------------------------------------------
-- design_utilities_pkg.vhdl
--------------------------------------------------------------------------------
--! \file design_utilities_pkg.vhdl
--! \brief Definition of the design_utilities_pkg package.
--!
--! \class design_utilities_pkg
--! \brief Package defining some useful functions for use
--! when implementing modules for synthesis.
--! \ingroup my_design_lib
--!
--------------------------------------------------------------------------------
-- $Revision: 18$
--------------------------------------------------------------------------------

library ieee;
use     ieee.std_logic_1164.all;
use     ieee.numeric_std.all;

package design_utilities_pkg is

    --! \brief Function to AND all bits in a std_logic_vector signal or variable.
    --! \param [in] S - std_logic_vector signal or variable.
    --! \result Logical AND of all bits in S.
    function COMBINE_AND (S : std_logic_vector) return std_logic;

end design_utilities_pkg;


--------------------------------------------------------------------------------
-- End of file design_utilities_pkg.vhdl
--------------------------------------------------------------------------------
