--------------------------------------------------------------------------------
-- design_components_pkg.vhdl
--------------------------------------------------------------------------------
--! \file design_components_pkg.vhdl
--! \brief Definition of the design_components_pkg package.
--!
--! \class design_components_pkg
--! \ingroup my_design_lib
--! \brief Package declaring library of reusable components for synthesis.
--!
--! This package provides component declarations for the entities in the
--! my_design_lib library.  Use this library to avoid the need to provide
--! component declarations.
--!
--------------------------------------------------------------------------------
-- $Revision: 36$
--------------------------------------------------------------------------------

library ieee;
use     ieee.std_logic_1164.all;

package design_components_pkg is


    ----------------------------------------------------------------------------
    --! addressable_shift_register component declaration
    ----------------------------------------------------------------------------
    component addressable_shift_register is

        generic
        (

            -- Width of the data ports
            NBITS_DATA              : positive := 16;

            -- Depth of the shift register, 5 -> 32, 6 -> 64
            LOG2_DEPTH              : positive := 5

        );

        port
        (

            -- Clock
            CLK                     : in    std_logic;

            -- Input data
            DATA_IN                 : in    std_logic_vector (NBITS_DATA - 1 downto 0);

            -- Input data clock enable
            DATA_IN_CE              : in    std_logic;

            -- Output data
            DATA_OUT                : out   std_logic_vector (NBITS_DATA - 1 downto 0);

            -- Output data address
            DATA_OUT_ADDR           : in    std_logic_vector (LOG2_DEPTH - 1 downto 0);

            -- Output data clock enable
            DATA_OUT_CE             : in    std_logic;

            -- Output data synchronous reset
            DATA_OUT_RST            : in    std_logic

        );

    end component;


end design_components_pkg;


--------------------------------------------------------------------------------
-- End of file design_components_pkg.vhdl
--------------------------------------------------------------------------------
