using Cairo;
using Gdk;

int main(string[] args)
{
	loop = new MainLoop();
		
	main_async();
	
	loop.run();
	return 0;
}

MainLoop loop;

async void main_async()
{
	Idle.add(main_async.callback);
	yield;
	
	ImageSurface srf = new ImageSurface(Format.ARGB32, 1000, 1000);
	Context cairoCtx = new Context(srf);
	cairoCtx.set_source_rgb(1, 1, 1);
	cairoCtx.paint();
	Pixbuf pixbuf = Gdk.pixbuf_get_from_surface(srf, 0, 0, 1000, 1000);

	File file = File.new_for_path("test-image.jpg");
	FileOutputStream stream = yield file.replace_async(null, false, FileCreateFlags.NONE);
	yield pixbuf.save_to_stream_async(stream, "jpeg");
	yield stream.close_async();
	
	loop.quit();
}
