#include "test.h"

GQuark 
ianjuta_project_error_quark (void)
{
	static GQuark quark = 0;
	
	if (quark == 0) {
		quark = g_quark_from_static_string ("ianjuta-project-quark");
	}
	
	return quark;
}

GType
ianjuta_project_error_get_type (void)
{
	static const GEnumValue values[] =
	{
		{ IANJUTA_PROJECT_ERROR_SUCCESS, "IANJUTA_PROJECT_ERROR_SUCCESS", "error-success" }, 
		{ IANJUTA_PROJECT_ERROR_DOESNT_EXIST, "IANJUTA_PROJECT_ERROR_DOESNT_EXIST", "error-doesnt-exist" }, 
		{ IANJUTA_PROJECT_ERROR_ALREADY_EXISTS, "IANJUTA_PROJECT_ERROR_ALREADY_EXISTS", "error-already-exists" }, 
		{ IANJUTA_PROJECT_ERROR_VALIDATION_FAILED, "IANJUTA_PROJECT_ERROR_VALIDATION_FAILED", "error-validation-failed" }, 
		{ IANJUTA_PROJECT_ERROR_PROJECT_MALFORMED, "IANJUTA_PROJECT_ERROR_PROJECT_MALFORMED", "error-project-malformed" }, 
		{ IANJUTA_PROJECT_ERROR_NOT_SUPPORTED, "IANJUTA_PROJECT_ERROR_NOT_SUPPORTED", "error-not-supported" }, 
		{ IANJUTA_PROJECT_ERROR_GENERAL_FAILURE, "IANJUTA_PROJECT_ERROR_GENERAL_FAILURE", "error-general-failure" }, 
		{ 0, NULL, NULL }
	};

	static GType type = 0;

	if (! type)
	{
		type = g_enum_register_static ("IAnjutaProjectError", values);
	}

	return type;
}

