
#ifndef INCLUDED_TSTVAULT1_H
#define INCLUDED_TSTVAULT1_H

/**
 * @file
 * <b>Driver Definitions 1</b>
 *
 * @b Description: Defines common datatypes.
 */

#if defined(__cplusplus)
extern "C"
{
#endif


/**
 * @defgroup VAULT_group TST Driver Definitions
 *
 * VAULT controls access.
 * @{
 */


/**
 * Defines details of VAULT attributes.
 */
typedef enum
{
    /**
     * Offset.
     */
    TSTVAULT1Attribute_ProcessingOffset = 0x4000,

    /**
     * Enabling anti-flicker.
     */
    TSTVAULT1Attribute_Anti,

    /**
     * Enabling auto.
     */
    TSTVAULT1Attribute_AutoRate,

    /**
     * Edges.
     */
    TSTVAULT1Attribute_Edges,

    /**
     * Enabling stylize.
     */
    TSTVAULT1Attribute_Stylize,

    /**
     * Enabling continuous auto.
     */
    TSTVAULT1Attribute_ContinuousAuto,

    /**
     * Pause continuous auto.
     */
    TSTVAULT1Attribute_ContinuousAutoPause,

    /**
     * Read only. Report.
     */
    TSTVAULT1Attribute_ContinuousAutoState,

    /**
     * Please use ::TSTVAULT1Attribute_Mode.
     */
    TSTVAULT1Attribute_ContinuousMode,

    /**
     * @deprecated Please use ::TSTVAULT1Attribute_Balance.
     */
    TSTVAULT1Attribute_ContinuousBalance,

    /**
     * Enabling reduction.
     */
    TSTVAULT1Attribute_Reduction,

    /**
     * The effective.
     */
    TSTVAULT1Attribute_Effective,

    /**
     * Auto white.
     */
    TSTVAULT1Attribute_White,

    /**
     * The auto rate.
     */
    TSTVAULT1Attribute_AutoRate,

    /** Ignore -- Forces compilers to make 32-bit enums. */
    TSTVAULT1Attribute_Force32 = 0x7FFFFFFF
} TSTVAULT1Attribute; // enum





#if defined(__cplusplus)
}
#endif

/** @} */

#endif // INCLUDED_TSTVAULT1_H
