
#ifndef INCLUDED_TSTVAULT3_H
#define INCLUDED_TSTVAULT3_H

/**
 * @file
 * <b>Driver Definitions 3</b>
 *
 * @b Description: Defines common datatypes.
 */

#if defined(__cplusplus)
extern "C"
{
#endif


/**
 * @defgroup VAULT3_group TST Driver 3 Definitions
 *
 * VAULT controls access.
 * @{
 */


/**
 * Defines details of VAULT attributes.
 */
typedef enum
{
    /**
     * Offset.
     */
    TSTVAULT3Attribute_ProcessingOffset = 0x4000,

    /**
     * Enabling anti-flicker.
     */
    TSTVAULT3Attribute_Anti,

    /**
     * Enabling auto.
     */
    TSTVAULT3Attribute_AutoRate,

    /**
     * Edges.
     */
    TSTVAULT3Attribute_Edges,

    /**
     * Enabling stylize.
     */
    TSTVAULT3Attribute_Stylize,

    /**
     * Enabling continuous auto.
     */
    TSTVAULT3Attribute_ContinuousAuto,

    /**
     * Pause continuous auto.
     */
    TSTVAULT3Attribute_ContinuousAutoPause,

    /**
     * Read only. Report.
     */
    TSTVAULT3Attribute_ContinuousAutoState,

    /**
     * Please use ::TSTVAULT3Attribute_Mode.
     */
    TSTVAULT3Attribute_ContinuousMode,

    /**
     * @deprecated Please use ::TSTVAULT3Attribute_Balance.
     */
    TSTVAULT3Attribute_ContinuousBalance,

    /**
     * Enabling reduction.
     */
    TSTVAULT3Attribute_Reduction,

    /**
     * The effective.
     */
    TSTVAULT3Attribute_Effective,

    /**
     * Auto white.
     */
    TSTVAULT3Attribute_White,

    /**
     * The auto rate.
     */
    TSTVAULT3Attribute_AutoRate,

    /** Ignore -- Forces compilers to make 32-bit enums. */
    TSTVAULT3Attribute_Force32 = 0x7FFFFFFF
} TSTVAULT3Attribute; // enum





#if defined(__cplusplus)
}
#endif

/** @} */

#endif // INCLUDED_TSTVAULT3_H
