
#ifndef INCLUDED_TSTVAULT2_H
#define INCLUDED_TSTVAULT2_H

/**
 * @file
 * <b>Driver Definitions 2</b>
 *
 * @b Description: Defines common datatypes.
 */

#if defined(__cplusplus)
extern "C"
{
#endif


/**
 * @addtogroup VAULT_group TST Driver 2 Definitions
 *
 * VAULT controls access.
 * @{
 */


/**
 * Defines details of VAULT attributes.
 */
typedef enum
{
    /**
     * Offset.
     */
    TSTVAULT2Attribute_ProcessingOffset = 0x4000,

    /**
     * Enabling anti-flicker.
     */
    TSTVAULT2Attribute_Anti,

    /**
     * Enabling auto.
     */
    TSTVAULT2Attribute_AutoRate,

    /**
     * Edges.
     */
    TSTVAULT2Attribute_Edges,

    /**
     * Enabling stylize.
     */
    TSTVAULT2Attribute_Stylize,

    /**
     * Enabling continuous auto.
     */
    TSTVAULT2Attribute_ContinuousAuto,

    /**
     * Pause continuous auto.
     */
    TSTVAULT2Attribute_ContinuousAutoPause,

    /**
     * Read only. Report.
     */
    TSTVAULT2Attribute_ContinuousAutoState,

    /**
     * Please use ::TSTVAULT2Attribute_Mode.
     */
    TSTVAULT2Attribute_ContinuousMode,

    /**
     * @deprecated Please use ::TSTVAULT2Attribute_Balance.
     */
    TSTVAULT2Attribute_ContinuousBalance,

    /**
     * Enabling reduction.
     */
    TSTVAULT2Attribute_Reduction,

    /**
     * The effective.
     */
    TSTVAULT2Attribute_Effective,

    /**
     * Auto white.
     */
    TSTVAULT2Attribute_White,

    /**
     * The auto rate.
     */
    TSTVAULT2Attribute_AutoRate,

    /** Ignore -- Forces compilers to make 32-bit enums. */
    TSTVAULT2Attribute_Force32 = 0x7FFFFFFF
} TSTVAULT2Attribute; // enum





#if defined(__cplusplus)
}
#endif

/** @} */

#endif // INCLUDED_TSTVAULT2_H
