﻿using System;
using System.Reflection;
using System.Threading;
using System.Windows;

namespace TestApplication
{
    public partial class MainWindow : Window
    {
        #region Private declarations

        private static readonly Gst.GLib.MainLoop messageLoop = new Gst.GLib.MainLoop();
        private readonly Gst.BasePlugins.PlayBin2 playBin = new Gst.BasePlugins.PlayBin2();

        #endregion Private declarations

        #region Constructors

        static MainWindow()
        {
            //initialize GStreamer
            string assemblyName = Assembly.GetExecutingAssembly().FullName;
            string[] args = new string[0];
            bool success = true;
            try
            {
                Gst.Application.InitCheck(assemblyName, ref args);
            }
            catch (ApplicationException)
            {
                success = false;
            }

            //run the GStreamer message loop on another thread
            if (success)
            {
                Thread messageLoopThread = new Thread(new ThreadStart(() => messageLoop.Run()));
                messageLoopThread.Name = "Video Main Loop";
                messageLoopThread.IsBackground = true;
                messageLoopThread.Start();
            }
        }

        public MainWindow()
        {
            InitializeComponent();

            // WARNING!
            // Uncommenting the following line will cause the application to crash after executing the event handler
            //playBin.VideoChanged += OnVideoChanged;

            string fileName = @"D:\VIDEO\test1.avi";
            playBin.Uri = @"file:///" + fileName.Replace('\\', '/');
            playBin.SetState(Gst.State.Playing);
        }

        #endregion Constructors

        #region Methods

        protected virtual void OnVideoChanged(object sender, Gst.GLib.SignalArgs args)
        {
            //do nothing
        }

        #endregion Methods
    }
}
