#include "keyboardEvents.h"


KeyboardEvents::KeyboardEvents ()
{
      // :: Radio buttons :: //

  first.set_label( "First" );
  second.set_label( "Second" );

  Gtk::RadioButton::Group group = first.get_group();

  second.set_group( group );


  first.set_active();


      // :: Main Container :: //

  container.add( first );
  container.add( second );


      // :: Window :: //

  this->add( container );

  this->set_title( "Keyboard Events" );

  this->set_border_width( 10 );

  this->show_all_children();


      // :: Events :: //

  this->add_events( Gdk::KEY_PRESS_MASK );


  this->signal_key_press_event().connect( sigc::mem_fun( *this, &KeyboardEvents::onKeyPress ) );
}



bool KeyboardEvents::onKeyPress( GdkEventKey *event )
{
      //GDK_MOD1_MASK -> the 'alt' key (mask)
      //GDK_KEY_1     -> the '1' key
      //GDK_KEY_2     -> the '2' key

      //select the first radio button, when we press alt + 1
  if ( (event->keyval == GDK_KEY_1) && (event->state == GDK_MOD1_MASK) )
    {
    first.set_active();
    }

      //and the second radio button, when we press alt + 2
  else if ( (event->keyval == GDK_KEY_2) && (event->state == GDK_MOD1_MASK) )
    {
    second.set_active();
    }


      //close the window, when the 'esc' key is pressed
  else if ( event->keyval == GDK_KEY_Escape )
    {
    on_hide();
    }


      //returning true, cancels the propagation of the event
  return true;
}
