/*
 * Copyright (c) 2009, Sun Microsystems, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  * Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the distribution.
 *  * Neither the name of Sun Microsystems, Inc. nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
//#############################################################################
/*!@mainpage Test for cite command
 *
 * @date    23.08.2011
 * @author  Stefan Goeckeritz, RheinAhrCampus Remagen
 * 
 * This is a test for the cite command in  in doxygen 1.7.5.1
 */
 // ############################################################################


#include "HelloForm.h"


/*!@details This function calculates test coefficients. It uses a formula
 * from @cite richard2005technische .
 * 
 * @since version 0.6
 * @see <a href="http://books.google.de/books?id=EpPDlXvOuAwC&lpg=PA223&ots=Y7ncHZoPbC&dq=%5B1%5D%20Technische%20Mechanik%20-%20Statik%2C%20Dynamik%2C%20Fluidmechanik%2C%20Festigkeitslehre%3B%20Alfred%20B%C3%B6ge%3B%20S.%2086&pg=PA88#v=onepage&q&f=false" title="Google Books entry">
 *      [1] Technische Mechanik - Statik, Dynamik, Fluidmechanik, Festigkeitslehre; Alfred Böge; S. 86
 *      </a>
 * @see <a href="http://books.google.de/books?id=-f_u97km2r4C&lpg=PA55&ots=NwHKZG1idZ&dq=standsicherheit%20machanik&pg=PA55#v=onepage&q=&f=false" title="Google Books entry">
 *      [2] Technische Mechanik - Statik; Hans Albert Richard,Manuela Sander; S. 55f
 *      </a>
 * @see <a href="http://books.google.de/books?id=cUUc2SXHgLwC&lpg=PA62&ots=T_6dXuv_Go&dq=standsicherheit%20machanik&pg=PA63#v=onepage&q=&f=false" title="Google Books entry">
 *      [3] Mechanik und Festigkeitslehre; Karlheinz Kabus; S. 63f
 *      </a>
 * @author  Stefan Göckeritz
 */
void HelloForm::calcTest()
{
	int test = 0;
}


