package com.facilita.fc.web;

import com.facilita.exception.BadValueException;
/**
* @enum  HttpStatus
*
* @brief HttpStatus
*
* Detailed description here bla bla
*
*/
public enum HttpStatus {

	NOT_SET(0,"not set message"){},
	CONTINUE(100,"OK to continue with request"){},
	SWITCH_PROTOCOLS(101,"server has switched protocols in upgrade header"){},

	OK(200,"request completed"){},
	CREATED(201,"object created, reason=newURI"){},
	ACCEPTED(202,"async completion(TBS)"){},
	NONAUTHORITATIVE_INFO(203,"partial completion"){},
	NO_CONTENT(204,"no info to return"){},
	RESET_CONTENT(205,"request completed, but clearform"){},
	PARTIAL_CONTENT(206,"partial GET fullfilled"){},

	AMBIGUOUS(300,"server couldn't decide what to return"){},
	MOVED_PERMANENTLY(301,"object permanently moved"){},
	REDIRECT(302,"object temporarily moved"){},
	REDIRECT_METHOD(303,"redirection/new access method"){},
	NOT_MODIFIED(304,"if-modified-since was not modified"){},
	USE_PROXY(305,"redirection to proxy, location header specifies proxy to use"){},
	REDIRECT_KEEP_VERB(307,"HTTP/1.1:keep same verb"){},

	BAD_REQUEST(400,"invalid syntax"){},
	DENIED(401,"unauthorized - access denied"){},
	PAYMENT_REQ(402,"payment required"){},
	FORBIDDEN(403,"request forbidden"){},
	NOT_FOUND(404,"object not found"){},
	METHOD_NOT_ALLOWED(405,"method is not allowed"){},
	NOT_ACCEPTABLE(406,"no response acceptable to client found"){},
	PROXY_AUTH_REQUIRED(407,"proxy authentication required"){},
	REQUEST_TIMEOUT(408,"server timedout waiting for request"){},
	CONFLICT(409,"user should resubmit with more info"){},
	GONE(410,"the source is no longer available"){},
	LENGTH_REQUIRED(411,"the server refused to accept request/length"){},
	PRECOND_FAILED(412,"precondition given in request failed"){},
	REQUEST_TOO_LARGE(413,"request entity was too large"){},
	URI_TOO_LONG(414,"request URI too long"){},
	UNSUPPORTED_MEDIA(415,"unsupported media type"){},
	RETRY_WITH(449,"retry after doing the appropriate action."){},

	SERVER_ERROR(500,"internal server error"){},
	NOT_SUPPORTED(501,"required not supported"){},
	BAD_GATEWAY(502,"error response received from gateway"){},
	SERVICE_UNAVAILABLE(503,"temporarily overloaded"){},
	GATEWAY_TIMEOUT(504,"timedout waiting for gateway"){},
	VERSION_NOT_SUPPORTED(505,"HTTP version not supported") {};


	public String message()
	{
		return _msg;
	}

	public int code()
	{
		return _code;
	}

	public boolean isValid()
	{
		return this != NOT_SET;
	}

	HttpStatus(int code, String msg)
	{
		_code = code;
		_msg = msg;
	}

	public static HttpStatus find(String name) throws BadValueException
	{
		throw new BadValueException("HttpStatus " +name + " not known");
	}

	private int _code;
	private String _msg;

}
