/**
 * @file
 * Example to illustrate some issues with namespace.
 */

/**
 * @brief This is the PLAT namespace.
 */
namespace PLAT {

    /** A simple enum defined within namespace PLAT. */
    enum MyNSType {
        mntOne /**< One. */,
        mntTwo /**< Two. */,
        mntThree /**< Three. */
    };

    /**
     * @brief A simple function declared within a namespace.
     *
     * It has parameters of types PLAT::MyNSType MyNSType and MyNSType .
     * @bug In the function overview of the namespace page, Doxygen should not
     * create a link from the type of parameter c to PLAT::MyNSType. \n
     * In the detailed description of the namespace page, Doxygen should
     * create a link to PLAT::MyNSType for parameter b. \n
     * In the function overview of the file reference page, Doxygen should
     * create a link to PLAT::MyNSType for parameter b. \n
     * In the bug list, Doxygen should create a link to PLAT::MyNSType for
     * parameter b.
     * @sa MyNSFunc2, PLAT::MyNSFunc2
     */
    MyNSType MyNSFunc1(PLAT::MyNSType a, MyNSType b, ::MyNSType c);

    /**
     * @brief Another simple function declared within a namespace.
     *
     * Detailed description.
     */
    PLAT::MyNSType MyNSFunc2(PLAT::MyNSType a, MyNSType b, ::MyNSType c);
}

/** A simple enum defined within the global namespace. */
enum MyGlobalType {
    mgtOne /**< One. */,
    mgtTwo /**< Two. */,
    mgtThree /**< Three. */
};

/**
 * @brief A simple function declared within the global namespace.
 *
 * It has parameters of types MyGlobalType and ::MyGlobalType .
 * @bug In the detailed description Doxygen should create a link for
 * MyGlobalType (i.e. the one without double colon prefix). \n
 * In the bug list Doxygen should create a link to MyGlobalType for parameter a.
 * @sa MyGlobalFunc2, ::MyGlobalFunc2
 */
MyGlobalType MyGlobalFunc1(MyGlobalType a, ::MyGlobalType b);

/**
 * @brief Another simple function declared within the global namespace.
 *
 * Detailed description.
 */
::MyGlobalType MyGlobalFunc2(MyGlobalType a, ::MyGlobalType b);
