/*
 * uridecodebin_test.c
 *
 *  Created on: Aug 12, 2010
 *      Author: wl
 */

#include <stdio.h>
#include <stdlib.h>
#include <gst/gst.h>

GstElement 	*pipeline;
GstElement  *decodebin;
GstElement 	*acodec,*vcodec,*muxer;
GstElement 	*filesink;
GstElement 	*mqueue;

GMainLoop 	*loop;

gboolean seek_done;

static void pad_added (GstPadTemplate * templ G_GNUC_UNUSED, GstPad * newpad, gpointer data)
{GstPad *q_sinkpad,*q_srcpad,*c_sinkpad,*c_srcpad,*mpad;
 GstPadLinkReturn r;
 GstIterator *it;
 gchar *caps;

 	 q_sinkpad=gst_element_get_request_pad(mqueue,"sink%d");

 	 it=gst_pad_iterate_internal_links(q_sinkpad);
 	 if (!it ||
 		 (gst_iterator_next (it, (gpointer) & q_srcpad)) != GST_ITERATOR_OK
 	      || q_srcpad == NULL) {
 	    g_print("Couldn't get srcpad from multiqueue for sinkpad %" GST_PTR_FORMAT, q_sinkpad);
 	    return;
 	 }
 	 gst_iterator_free(it);

 	 caps=gst_caps_to_string(gst_pad_get_caps(newpad));
 	 g_print("pad_added, new pad caps: %s\n",caps);
 	 if(g_strrstr(caps,"video")){
 		 c_sinkpad=gst_element_get_compatible_pad(vcodec,newpad,gst_pad_get_caps(newpad));
 		 c_srcpad=gst_element_get_static_pad(vcodec,"src");
 	 }else{
 		 c_sinkpad=gst_element_get_compatible_pad(acodec,newpad,gst_pad_get_caps(newpad));
 		 c_srcpad=gst_element_get_static_pad(acodec,"src");
 	 }
 	 g_free(caps);

 	 mpad=gst_element_get_compatible_pad(muxer,c_srcpad,gst_pad_get_caps(c_srcpad));

 	 r=gst_pad_link(newpad,q_sinkpad);
 	 g_print("pad_added, linked %s:%s to %s:%s result=%d\n",GST_DEBUG_PAD_NAME(newpad),GST_DEBUG_PAD_NAME(q_sinkpad),r);
 	 r=gst_pad_link(q_srcpad,c_sinkpad);
 	 g_print("pad_added, linked %s:%s to %s:%s result=%d\n",GST_DEBUG_PAD_NAME(q_srcpad),GST_DEBUG_PAD_NAME(c_sinkpad),r);
 	 r=gst_pad_link(c_srcpad,mpad);
 	 g_print("pad_added, linked %s:%s to %s:%s result=%d\n",GST_DEBUG_PAD_NAME(c_srcpad),GST_DEBUG_PAD_NAME(mpad),r);

 	 gst_object_unref(q_srcpad);
 	 gst_object_unref(q_sinkpad);
 	 gst_object_unref(c_srcpad);
 	 gst_object_unref(c_sinkpad);
 	 gst_object_unref(mpad);

 	 if(data)
		GST_DEBUG_BIN_TO_DOT_FILE_WITH_TS(GST_BIN(data),GST_DEBUG_GRAPH_SHOW_ALL,"decodebin");
}

gboolean bus_call(GstBus *bus, GstMessage *msg, gpointer data)
{
	switch(GST_MESSAGE_TYPE(msg)){
		case GST_MESSAGE_SEGMENT_DONE:
		case GST_MESSAGE_EOS:
			g_print("eos\n");
			g_main_loop_quit(loop);
			return FALSE;
		case GST_MESSAGE_ERROR:{
			GError *err;
			gchar *debug;

			gst_message_parse_error (msg, &err, &debug);
			g_print ("Error: %s\n", err->message);
			g_error_free (err);

			if (debug) {
				g_print ("Debug deails: %s\n", debug);
				g_free (debug);
			}
			g_main_loop_quit(loop);
			return FALSE;
		}
		case GST_MESSAGE_STATE_CHANGED:{
			GstState old,new,pend;
			gst_message_parse_state_changed(msg,&old,&new,&pend);
			g_print("message state changed from %s: old:%d, new:%d, pending:%d\n",GST_MESSAGE_SRC_NAME(msg),
					old,new,pend);
			if(!seek_done && GST_MESSAGE_SRC(msg)==GST_OBJECT(pipeline) && new==GST_STATE_PLAYING){
				gboolean rs;
				seek_done=TRUE;
				rs=gst_element_seek(pipeline,
							1.0,
							GST_FORMAT_TIME,
							GST_SEEK_FLAG_FLUSH|GST_SEEK_FLAG_ACCURATE|GST_SEEK_FLAG_SEGMENT,
							GST_SEEK_TYPE_SET,
							5LL*GST_SECOND,
							GST_SEEK_TYPE_SET,
							15LL*GST_SECOND
							);
				g_print("doing segment seek: result=%d\n",rs);
			}
			return TRUE;
		}
		default:
			if(GST_MESSAGE_TYPE(msg)!=GST_MESSAGE_WARNING || g_strrstr(GST_MESSAGE_SRC_NAME(msg),"mpeg2dec")==NULL)
				g_print("message %s(%d) from %s\n",GST_MESSAGE_TYPE_NAME(msg),GST_MESSAGE_TYPE(msg),GST_MESSAGE_SRC_NAME(msg));
			return TRUE;
	}
}

int main(int argc,char *argv[])
{
	GstBus *bus;
	GTimeVal timeval;
	gboolean wait_result;
	GstFormat format;
	gint64 position, duration;
	gboolean stream_dump;
	gchar *location="file:///home/wl/AVIK/video/198640.mpg";

	g_thread_init(NULL);
	gst_init(&argc,&argv);

	loop=g_main_loop_new(NULL,FALSE);
	pipeline = gst_pipeline_new("pipeline");
	bus = gst_pipeline_get_bus(GST_PIPELINE(pipeline));
	gst_bus_enable_sync_message_emission(bus);
	gst_bus_add_watch(bus,bus_call,NULL);

	decodebin = gst_element_factory_make("uridecodebin","ubin");
	g_object_set(decodebin,"uri",location,NULL);
	g_signal_connect(G_OBJECT(decodebin),"pad-added",G_CALLBACK(pad_added),pipeline);

	mqueue = gst_element_factory_make("multiqueue","mqueue");

	acodec = gst_element_factory_make("twolame","acodec");
	vcodec = gst_element_factory_make("mpeg2enc","vcodec");

	muxer = gst_element_factory_make("mpegpsmux","mux");
	filesink = gst_element_factory_make("filesink","sink");
	g_object_set(filesink,"location","/home/wl/AVIK/video/dectsaved.mpg",NULL);

	gst_bin_add_many(GST_BIN(pipeline),decodebin,mqueue,acodec,vcodec,muxer,filesink,NULL);

	gst_element_link(muxer,filesink);

	seek_done = FALSE;
	gst_element_set_state(pipeline,GST_STATE_PLAYING);

	g_main_loop_run(loop);

	g_print("Return from main app\n");
	return EXIT_SUCCESS;
}
