/*#######################################################################
##
## name: codeFlow_mark
##
## task: Knotenpassage mitteilen
##                          
## History:
##  23.06.2010: beb: v1.06.083: entworfen
##  25.06.2010: beb: v1.07.004: erste Tests bestanden
##  29.06.2010: beb: v1.07.020: wahrscheinlich gefixed durch erneute Abfrage des Knotens
##  29.06.2010: beb: v1.07.020: geprft
## 
#######################################################################*/
/// <summary>Knotenpassage mitteilen</summary>
/// <param name="grafBez"   >Kennung des Graphen</param>
/// <param name="nodeName"  >Knotenkennung<br>... mit Punkten umgeben (z.B.<c>.enter.</c>)</param>
/// <param name="nodeHint"  >(optionaler) Hinweis als Beschreibung fr den Knoten</param>
/// <returns>Erfolgsmeldung (0:OK)</returns>
/// <remarks>
/// Details siehe 'Dokumentationsmuster' unter <see cref="rvsMachine::rvsMachine_Calc::CodeFlow" />
/// <ul>
/// <li>Der optionale Hinweis ist nur sinnvoll, wenn der Knoten
///     <b>nicht zuvor</b> mit der Methode <c>codeFlow_earl</c> angemeldet wurde.
/// </ul>
/// </remarks>
   internal int codeFlow_mark( string grafBez, string nodeName, string nodeHint ) // Knotenpassage markieren (ggf. implizit Knoten oder Graph registrieren)
// ==============================================================================
{
   NODEINFO ni;
   int      antwort=0,
            ip,
            idxGraf;
   string   nodeNorm; // normalisierter Knotenname

   /// <hr>Grafik muss existieren
   if( !catalog.TryGetValue( grafBez, out idxGraf ) )
   {
     /// \todo (3) beb : 23.06.2010 16:59
     /// <br>Es knnte auch eine Dummy-Grafik erzeugt werden
     if( 0 > (idxGraf=codeFlow_graf( grafBez ) ) ) // Grafikspeicher erzeugen und vorbereiten
     {
       return( antwort=-1 ); // unbekannte Grafik 'grafBez'
     }
   }
   /// <hr>Knoten aus Punkten befreien
   nodeNorm = nodeName.Trim();

   while( 0 <= (ip=nodeNorm.IndexOf( '.' ) ) )
   {
     nodeNorm = nodeNorm.Remove( ip, 1 ); // Punkt entfernen
   };

   /// <hr>Falls Knoten fehlt ... 
   if( !nodeinfo[idxGraf].TryGetValue( nodeNorm, out ni ) ) // ggf. neu aufnehmen
   {
     /// <hr>Falls Knoten nicht mit <c>codeFlow_earl</c> angemeldet sind...
     /// <br>... kommt's hier erstmal zu Misstimmigkeiten.
     ///     Wenn beim Benennen der Knoten einige Standards eingehalten wurden,
     ///     fllen wir diese Knoten nachtrglich ein.
     if( !codeFlow_auto( idxGraf, nodeNorm, nodeHint ) ) // konnte nicht gelst werden
     {
       return( antwort=-2 ); // unbekannter Knoten 'strNode' in Grafik 'grafBez'
     }

     if( !nodeinfo[idxGraf].TryGetValue( nodeNorm, out ni ) ) // gibt's denn jetzt endlich einen Knoten ?
     {
       return( antwort=-6 ); // ganz bld, erzeugter Knoten existiert doch nicht
     }
   }

   /// <hr>Knotenpassage zhlen
   ni.many++;    // Inkrementierung wirkt (erstmal) nur auf die Kopie von NODEINFO zurck ?
   nodeinfo[idxGraf][nodeNorm] = ni; // das gespeicherte Attribut(NODEINFO) wird erneuert

   /// <hr>Kantenweg (selektiv fr eine Grafik) merken ... falls berhaupt sinnvoll.
   if( 0 < nodelast[idxGraf].Length     // Knotenname scheint sinnvoll
   &&  nodelast[idxGraf] != "leave"     // Grafik bereits verlassen
   &&  nodeNorm          != "enter" )   // Grafik wird frisch betreten
   {
     codeFlow_edge( idxGraf, nodeNorm ); // Verbindung merken und ggf. Zhler erhnen     
   }   
   nodelast[idxGraf] = nodeNorm; // merke den aktuellen Knoten fr nchsten Kontakt

   return( antwort ); // 0:OK -1:Fehler -2:Fehler
   /// <hr>
} // codeFlow_mark