/*
 * Decompiled with CFR 0.152.
 */
package org.GNOME.Accessibility;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleEditableText;
import javax.accessibility.AccessibleText;
import javax.swing.text.AttributeSet;
import org.GNOME.Accessibility.JavaBridge;
import org.GNOME.Accessibility.TEXT_BOUNDARY_TYPE;
import org.GNOME.Accessibility.TEXT_CLIP_TYPE;
import org.GNOME.Accessibility.TextOperations;
import org.GNOME.Accessibility.TextPOATie;
import org.GNOME.Accessibility.TextPackage.Range;
import org.GNOME.Bonobo.UnknownImpl;
import org.omg.CORBA.IntHolder;

public class TextImpl
extends UnknownImpl
implements TextOperations {
    AccessibleText accText;
    AccessibleEditableText accEditableText;
    AccessibleContext ac;
    static final int LINE_PART = 4;

    public TextImpl(AccessibleContext accessibleContext) {
        this.accText = accessibleContext.getAccessibleText();
        this.accEditableText = accessibleContext.getAccessibleEditableText();
        this.ac = accessibleContext;
        this.poa = JavaBridge.getRootPOA();
        this.tie = new TextPOATie(this, JavaBridge.getRootPOA());
        try {
            JavaBridge.getRootPOA().activate_object(this.tie);
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        JavaBridge.setInitialTextSize(accessibleContext, this.characterCount());
    }

    public int characterCount() {
        int n = 0;
        try {
            if (this.accText != null) {
                n = this.accText.getCharCount();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public int caretOffset() {
        int n = 0;
        try {
            if (this.accText != null) {
                n = this.accText.getCaretPosition();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (n < 0) {
            return 0;
        }
        return n;
    }

    public String getText(int n, int n2) {
        return TextImpl.getText(this.accText, this.accEditableText, n, n2);
    }

    public static String getText(AccessibleText accessibleText, AccessibleEditableText accessibleEditableText, int n, int n2) {
        String string;
        block13: {
            string = "";
            try {
                int n3 = accessibleText.getCharCount();
                if (n < 0) {
                    n = 0;
                }
                if (n2 >= n3 || n2 == -1) {
                    n2 = n3;
                } else if (n2 < -1) {
                    n2 = 0;
                }
                if (accessibleEditableText != null) {
                    try {
                        String string2 = accessibleEditableText.getTextRange(n, n2);
                        if (string2 != null) {
                            string = string2;
                        }
                        break block13;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    break block13;
                }
                if (accessibleText != null) {
                    int n4 = n;
                    String string3 = accessibleText.getAtIndex(2, n);
                    while (n4 < n2 && string3 == accessibleText.getAtIndex(2, n4)) {
                        String string4 = accessibleText.getAtIndex(1, n4);
                        ++n4;
                        if (string4 == null) continue;
                        string = string + string4;
                    }
                    while (n4 < n2) {
                        string = (n4 += (string3 = accessibleText.getAtIndex(2, n4)).length()) > n2 ? string + string3.substring(0, string3.length() - (n4 - n2)) : string + string3;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return string;
    }

    public boolean setCaretOffset(int n) {
        return false;
    }

    private boolean overlapsVertically(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle == null | rectangle2 == null) {
            return false;
        }
        if (rectangle.y == rectangle2.y) {
            return true;
        }
        int n = rectangle.y;
        int n2 = rectangle.y + rectangle.height;
        int n3 = rectangle2.y;
        int n4 = rectangle2.y + rectangle2.height;
        return n2 == n4 || n > n3 && n < n4 || n3 > n && n3 < n2 || n2 > n3 && n2 < n4 || n4 > n && n4 < n2;
    }

    private StringStruct getLine(AccessibleText accessibleText, int n) {
        String string = null;
        StringStruct stringStruct = new StringStruct();
        int n2 = n;
        int n3 = n;
        try {
            int n4 = accessibleText.getCharCount() - 1;
            Rectangle rectangle = accessibleText.getCharacterBounds(n);
            Rectangle rectangle2 = null;
            if (rectangle == null && n > 0) {
                rectangle = accessibleText.getCharacterBounds(n - 1);
            }
            do {
                rectangle2 = accessibleText.getCharacterBounds(--n2);
            } while (n2 > 0 && this.overlapsVertically(rectangle, rectangle2));
            rectangle2 = rectangle;
            while (n3 < n4 && this.overlapsVertically(rectangle, rectangle2)) {
                rectangle2 = accessibleText.getCharacterBounds(++n3);
            }
            string = this.getText(n2, n3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        stringStruct.startOffset = n2;
        stringStruct.endOffset = n3;
        stringStruct.string = string == null ? "" : string;
        return stringStruct;
    }

    private String concatenateText(AccessibleText accessibleText, String string, TEXT_BOUNDARY_TYPE tEXT_BOUNDARY_TYPE, int n) {
        try {
            int n2 = this.boundaryTypeConvert(tEXT_BOUNDARY_TYPE);
            if (n < 0 || n > accessibleText.getCharCount()) {
                return "";
            }
            if (tEXT_BOUNDARY_TYPE == TEXT_BOUNDARY_TYPE.TEXT_BOUNDARY_WORD_START || tEXT_BOUNDARY_TYPE == TEXT_BOUNDARY_TYPE.TEXT_BOUNDARY_SENTENCE_START) {
                String string2 = accessibleText.getBeforeIndex(n2, n);
                if (string2 != null) {
                    string = string2 + string;
                }
            } else {
                String string3 = accessibleText.getAfterIndex(n2, n);
                if (string3 != null) {
                    string = string + string3;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    private String concatenateWhitespace(AccessibleText accessibleText, String string, TEXT_BOUNDARY_TYPE tEXT_BOUNDARY_TYPE, int n) {
        try {
            int n2 = this.boundaryTypeConvert(tEXT_BOUNDARY_TYPE);
            if (n < 0 || n > accessibleText.getCharCount()) {
                return "";
            }
            if (tEXT_BOUNDARY_TYPE == TEXT_BOUNDARY_TYPE.TEXT_BOUNDARY_WORD_START || tEXT_BOUNDARY_TYPE == TEXT_BOUNDARY_TYPE.TEXT_BOUNDARY_SENTENCE_START) {
                String string2 = accessibleText.getAfterIndex(n2, n);
                if (string2 != null && string2.trim().length() > 0) {
                    string = string + string2;
                }
            } else {
                String string3 = accessibleText.getBeforeIndex(n2, n);
                if (string3 != null && string3.trim().length() > 0) {
                    string = string3 + string;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    private int boundaryTypeConvert(TEXT_BOUNDARY_TYPE tEXT_BOUNDARY_TYPE) {
        int n = tEXT_BOUNDARY_TYPE == TEXT_BOUNDARY_TYPE.TEXT_BOUNDARY_LINE_START || tEXT_BOUNDARY_TYPE == TEXT_BOUNDARY_TYPE.TEXT_BOUNDARY_LINE_END ? 4 : (tEXT_BOUNDARY_TYPE == TEXT_BOUNDARY_TYPE.TEXT_BOUNDARY_WORD_START || tEXT_BOUNDARY_TYPE == TEXT_BOUNDARY_TYPE.TEXT_BOUNDARY_WORD_END ? 2 : (tEXT_BOUNDARY_TYPE == TEXT_BOUNDARY_TYPE.TEXT_BOUNDARY_SENTENCE_START || tEXT_BOUNDARY_TYPE == TEXT_BOUNDARY_TYPE.TEXT_BOUNDARY_SENTENCE_END ? 3 : 1));
        return n;
    }

    private StringStruct findOffsets(AccessibleText accessibleText, String string, int n) {
        StringStruct stringStruct = new StringStruct();
        int n2 = string.length();
        String string2 = this.getText(n - n2, n + n2);
        int n3 = string2.indexOf(string);
        if ((n -= n2) < 0) {
            n = 0;
        }
        stringStruct.startOffset = n += n3;
        stringStruct.endOffset = n + n2;
        return stringStruct;
    }

    private StringStruct getBoundedString(AccessibleText accessibleText, TEXT_BOUNDARY_TYPE tEXT_BOUNDARY_TYPE, int n) {
        String string = null;
        StringStruct stringStruct = new StringStruct();
        try {
            if (tEXT_BOUNDARY_TYPE == TEXT_BOUNDARY_TYPE.TEXT_BOUNDARY_LINE_START || tEXT_BOUNDARY_TYPE == TEXT_BOUNDARY_TYPE.TEXT_BOUNDARY_LINE_END) {
                int n2 = this.boundaryTypeConvert(tEXT_BOUNDARY_TYPE);
                string = accessibleText.getAtIndex(n2, n);
                if (string == null) {
                    return this.getLine(accessibleText, n);
                }
            } else {
                int n3 = this.boundaryTypeConvert(tEXT_BOUNDARY_TYPE);
                string = accessibleText.getAtIndex(n3, n);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (string == null) {
            stringStruct.string = "";
        } else {
            stringStruct = this.findOffsets(accessibleText, string, n);
            stringStruct.string = string;
        }
        return stringStruct;
    }

    public String getTextBeforeOffset(int n, TEXT_BOUNDARY_TYPE tEXT_BOUNDARY_TYPE, IntHolder intHolder, IntHolder intHolder2) {
        String string = "";
        try {
            if (this.accText != null) {
                StringStruct stringStruct = this.getBoundedString(this.accText, tEXT_BOUNDARY_TYPE, n);
                if (stringStruct.string != null) {
                    string = stringStruct.string;
                }
                if (tEXT_BOUNDARY_TYPE != TEXT_BOUNDARY_TYPE.TEXT_BOUNDARY_LINE_START && tEXT_BOUNDARY_TYPE != TEXT_BOUNDARY_TYPE.TEXT_BOUNDARY_LINE_END && tEXT_BOUNDARY_TYPE != TEXT_BOUNDARY_TYPE.TEXT_BOUNDARY_CHAR) {
                    string = string.trim().length() == 0 ? this.concatenateText(this.accText, string, tEXT_BOUNDARY_TYPE, n - stringStruct.string.length()) : this.concatenateWhitespace(this.accText, string, tEXT_BOUNDARY_TYPE, n - stringStruct.string.length());
                    stringStruct = this.findOffsets(this.accText, string, n);
                }
                intHolder.value = stringStruct.startOffset;
                intHolder2.value = stringStruct.endOffset;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    public String getTextAtOffset(int n, TEXT_BOUNDARY_TYPE tEXT_BOUNDARY_TYPE, IntHolder intHolder, IntHolder intHolder2) {
        String string = "";
        try {
            if (this.accText != null) {
                StringStruct stringStruct = this.getBoundedString(this.accText, tEXT_BOUNDARY_TYPE, n);
                if (stringStruct.string != null) {
                    string = stringStruct.string;
                }
                if (tEXT_BOUNDARY_TYPE != TEXT_BOUNDARY_TYPE.TEXT_BOUNDARY_LINE_START && tEXT_BOUNDARY_TYPE != TEXT_BOUNDARY_TYPE.TEXT_BOUNDARY_LINE_END && tEXT_BOUNDARY_TYPE != TEXT_BOUNDARY_TYPE.TEXT_BOUNDARY_CHAR) {
                    string = string.trim().length() == 0 ? this.concatenateText(this.accText, string, tEXT_BOUNDARY_TYPE, n) : this.concatenateWhitespace(this.accText, string, tEXT_BOUNDARY_TYPE, n);
                    stringStruct = this.findOffsets(this.accText, string, n);
                }
                intHolder.value = stringStruct.startOffset;
                intHolder2.value = stringStruct.endOffset;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    public String getTextAfterOffset(int n, TEXT_BOUNDARY_TYPE tEXT_BOUNDARY_TYPE, IntHolder intHolder, IntHolder intHolder2) {
        String string = "";
        try {
            if (this.accText != null) {
                StringStruct stringStruct = this.getBoundedString(this.accText, tEXT_BOUNDARY_TYPE, n);
                if (stringStruct.string != null) {
                    string = stringStruct.string;
                }
                if (tEXT_BOUNDARY_TYPE != TEXT_BOUNDARY_TYPE.TEXT_BOUNDARY_LINE_START && tEXT_BOUNDARY_TYPE != TEXT_BOUNDARY_TYPE.TEXT_BOUNDARY_LINE_END && tEXT_BOUNDARY_TYPE != TEXT_BOUNDARY_TYPE.TEXT_BOUNDARY_CHAR) {
                    string = string.trim().length() == 0 ? this.concatenateText(this.accText, string, tEXT_BOUNDARY_TYPE, n + stringStruct.string.length()) : this.concatenateWhitespace(this.accText, string, tEXT_BOUNDARY_TYPE, n + stringStruct.string.length());
                    stringStruct = this.findOffsets(this.accText, string, n);
                }
                intHolder.value = stringStruct.startOffset;
                intHolder2.value = stringStruct.endOffset;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    public int getCharacterAtOffset(int n) {
        try {
            if (this.accText != null) {
                return this.accText.getAtIndex(1, n).charAt(0);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return 0;
    }

    private String attributeSetConvert(AttributeSet attributeSet) {
        String string = "";
        Enumeration<?> enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Color color;
            Object obj = enumeration.nextElement();
            Object object = attributeSet.getAttribute(obj);
            String string2 = obj.toString();
            String string3 = object.toString();
            if (string2.equals("family")) {
                string = string + "family-name:" + string3;
            } else if (string2.equals("size")) {
                string = string + string2 + ":" + string3;
            } else if (string2.equals("italic")) {
                string = Boolean.valueOf(string3).booleanValue() ? string + "style:italic" : string + "style:normal";
            } else if (string2.equals("bold")) {
                string = Boolean.valueOf(string3).booleanValue() ? string + "weight:700" : string + "weight:400";
            } else if (string2.equals("foreground") || string2.equals("color")) {
                if (object instanceof Color) {
                    color = (Color)object;
                    string = string + "fg-color:";
                    string = string + (color.getRed() * 256 + color.getRed());
                    string = string + ",";
                    string = string + (color.getGreen() * 256 + color.getGreen());
                    string = string + ",";
                    string = string + (color.getBlue() * 256 + color.getBlue());
                }
            } else if (string2.equals("background")) {
                if (object instanceof Color) {
                    color = (Color)object;
                    string = string + "bg-color:";
                    string = string + (color.getRed() * 256 + color.getRed());
                    string = string + ",";
                    string = string + (color.getGreen() * 256 + color.getGreen());
                    string = string + ",";
                    string = string + (color.getBlue() * 256 + color.getBlue());
                }
            } else if (string2.equals("underline")) {
                string = string + "underline:";
                string = Boolean.valueOf(string3).booleanValue() ? string + "single" : string + "none";
            } else {
                string = string2.equals("strikethrough") ? string + "strikethrough:" + Boolean.valueOf(string3) : string + string2 + ":" + string3;
            }
            if (!enumeration.hasMoreElements()) continue;
            string = string + ",  ";
        }
        return string;
    }

    public String getAttributes(int n, IntHolder intHolder, IntHolder intHolder2) {
        int n2 = n;
        int n3 = n;
        int n4 = -1;
        try {
            if (this.accText != null) {
                AttributeSet attributeSet;
                AttributeSet attributeSet2 = this.accText.getCharacterAttribute(n);
                n4 = this.accText.getCharCount();
                if (--n2 > 0) {
                    attributeSet = this.accText.getCharacterAttribute(n2);
                    while (n2 > 0 && (attributeSet2 == null && attributeSet2 == attributeSet || attributeSet2 != null && attributeSet != null && attributeSet2.isEqual(attributeSet))) {
                        attributeSet = this.accText.getCharacterAttribute(--n2);
                        System.err.println("start = " + n2);
                    }
                }
                if (++n3 < n4) {
                    attributeSet = this.accText.getCharacterAttribute(n3);
                    while (n3 < n4 && (attributeSet2 == null && attributeSet2 == attributeSet || attributeSet2 != null && attributeSet != null && attributeSet2.isEqual(attributeSet))) {
                        attributeSet = this.accText.getCharacterAttribute(++n3);
                        System.err.println("end = " + n3);
                    }
                }
                intHolder.value = ++n2;
                intHolder2.value = n3;
                if (attributeSet2 != null) {
                    return this.attributeSetConvert(attributeSet2);
                }
                return "";
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        intHolder.value = n;
        intHolder2.value = n4 < 0 ? n + 1 : n4;
        return "";
    }

    private Point getToplevelLocationOnScreen() {
        Point point = new Point(0, 0);
        Accessible accessible = this.ac.getAccessibleParent();
        AccessibleContext accessibleContext = this.ac;
        AccessibleComponent accessibleComponent = accessibleContext.getAccessibleComponent();
        while (accessible != null && accessibleComponent != null) {
            Point point2 = accessibleComponent.getLocation();
            point.x += point2.x;
            point.y += point2.y;
            accessible = accessibleContext.getAccessibleParent();
            accessibleContext = accessible.getAccessibleContext();
            accessibleComponent = accessibleContext.getAccessibleComponent();
        }
        return point;
    }

    public void getCharacterExtents(int n, IntHolder intHolder, IntHolder intHolder2, IntHolder intHolder3, IntHolder intHolder4, short s) {
        block8: {
            try {
                Object object;
                Rectangle rectangle = null;
                if (this.accText == null) break block8;
                rectangle = this.accText.getCharacterBounds(n);
                if (rectangle == null) {
                    if (n > 0) {
                        rectangle = this.accText.getCharacterBounds(n - 1);
                    }
                    if (rectangle == null) {
                        return;
                    }
                    rectangle.height = 0;
                    rectangle.width = 0;
                }
                try {
                    object = this.ac.getAccessibleComponent();
                    Point point = object.getLocationOnScreen();
                    rectangle.x += point.x;
                    rectangle.y += point.y;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (s != 0) {
                    object = this.getToplevelLocationOnScreen();
                    rectangle.x -= ((Point)object).x;
                    rectangle.y -= ((Point)object).y;
                }
                intHolder.value = rectangle.x;
                intHolder2.value = rectangle.y;
                intHolder4.value = rectangle.height;
                intHolder3.value = rectangle.width;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public int getOffsetAtPoint(int n, int n2, short s) {
        int n3 = 0;
        try {
            if (this.accText != null) {
                n3 = this.accText.getIndexAtPoint(new Point(n, n2));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n3;
    }

    public int getNSelections() {
        try {
            if (this.accText != null) {
                String string = this.accText.getSelectedText();
                return string == null || string.length() == 0 ? 0 : 1;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return 0;
    }

    public void getSelection(int n, IntHolder intHolder, IntHolder intHolder2) {
        try {
            if (n == 0) {
                intHolder.value = this.accText.getSelectionStart();
                intHolder2.value = this.accText.getSelectionEnd();
            } else {
                intHolder.value = 0;
                intHolder2.value = 0;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean addSelection(int n, int n2) {
        try {
            if (this.accEditableText != null && this.getNSelections() == 0) {
                return this.setSelection(0, n, n2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    public boolean removeSelection(int n) {
        try {
            if (this.accEditableText != null && n == 0) {
                this.accEditableText.selectText(0, 0);
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    public boolean setSelection(int n, int n2, int n3) {
        try {
            if (this.accEditableText != null && n == 0) {
                this.accEditableText.selectText(n2, n3);
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    public void getRangeExtents(int n, int n2, IntHolder intHolder, IntHolder intHolder2, IntHolder intHolder3, IntHolder intHolder4, short s) {
    }

    public Range[] getBoundedRanges(int n, int n2, int n3, int n4, short s, TEXT_CLIP_TYPE tEXT_CLIP_TYPE, TEXT_CLIP_TYPE tEXT_CLIP_TYPE2) {
        return new Range[0];
    }

    public void unImplemented() {
    }

    public void unImplemented2() {
    }

    public void unImplemented3() {
    }

    public void unImplemented4() {
    }

    public void unImplemented7() {
    }

    public void unImplemented8() {
    }

    private String typeToString(TEXT_BOUNDARY_TYPE tEXT_BOUNDARY_TYPE) {
        String string;
        switch (tEXT_BOUNDARY_TYPE.value()) {
            case 0: {
                string = "_TEXT_BOUNDARY_CHAR";
                break;
            }
            case 1: {
                string = "_TEXT_BOUNDARY_WORD_START";
                break;
            }
            case 2: {
                string = "_TEXT_BOUNDARY_WORD_END";
                break;
            }
            case 3: {
                string = "_TEXT_BOUNDARY_SENTENCE_START";
                break;
            }
            case 4: {
                string = "_TEXT_BOUNDARY_SENTENCE_END";
                break;
            }
            case 5: {
                string = "_TEXT_BOUNDARY_LINE_START";
                break;
            }
            case 6: {
                string = "_TEXT_BOUNDARY_LINE_END";
                break;
            }
            default: {
                string = "UNKNOWN!!!";
            }
        }
        return string;
    }

    public class StringStruct {
        public int startOffset;
        public int endOffset;
        public String string;
    }
}

