/*
 * Decompiled with CFR 0.152.
 */
package org.GNOME.Accessibility;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Hashtable;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleEditableText;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleText;
import javax.swing.SwingUtilities;
import org.GNOME.Accessibility.AccessUtil;
import org.GNOME.Accessibility.Accessible;
import org.GNOME.Accessibility.AccessibleFactory;
import org.GNOME.Accessibility.Application;
import org.GNOME.Accessibility.ApplicationAccessible;
import org.GNOME.Accessibility.DeviceEvent;
import org.GNOME.Accessibility.Event;
import org.GNOME.Accessibility.KeyEventAdapter;
import org.GNOME.Accessibility.StateTypeAdapter;
import org.GNOME.Accessibility.TextImpl;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.PortableServer.POA;

public class JavaBridge {
    static PropertyChangeListener globalPropertyChangeListener = null;
    static FocusListener focusListener = null;
    static AccessibleFactory accessibleObjectFactory = null;
    static Hashtable accessibleObjectTable = new Hashtable();
    static EventQueue accessQueue = null;
    javax.accessibility.Accessible appAccessible;
    private static HashMap lastTextSizes;
    private static final int max_recurse_depth = 10;
    private static final int max_children_block = 200;

    public static void main(String[] stringArray) {
        new JavaBridge();
    }

    public JavaBridge() {
        System.err.println("Java Accessibility Bridge for GNOME loaded.\n");
        String string = System.getProperty("java.version");
        if (string.compareTo("1.4.0") < 0) {
            System.err.println("WARNING: Java Accessibility Bridge for GNOME requires JVM version 1.4.0 or greater.");
        } else {
            this.registerApplication();
        }
    }

    public JavaBridge(String[] stringArray) {
        System.err.println(stringArray);
        new JavaBridge();
    }

    public static POA getRootPOA() {
        return AccessUtil.getRootPOA();
    }

    public static AccessibleFactory getAccessibleObjectFactory() {
        return accessibleObjectFactory;
    }

    public static Hashtable getAccessibleObjectTable() {
        return accessibleObjectTable;
    }

    public static PropertyChangeListener getGlobalPropertyChangeListener() {
        return globalPropertyChangeListener;
    }

    public static FocusListener getFocusListener() {
        return focusListener;
    }

    public static void dispatchWindowEvent(Object object, String string) {
        try {
            if (object instanceof javax.accessibility.Accessible) {
                JavaBridge.dispatchEvent(((javax.accessibility.Accessible)object).getAccessibleContext(), string, 0, 0);
            }
        }
        catch (Exception exception) {
            System.err.println(exception + " caught.");
            exception.printStackTrace();
        }
    }

    public static void dispatchEvent(Object object, String string, int n, int n2) {
        JavaBridge.dispatchEvent(object, string, n, n2, null);
    }

    public static void dispatchEvent(Object object, String string, int n, int n2, Object object2) {
        ORB oRB = AccessUtil.getORB();
        Any any = oRB.create_any();
        if (object2 != null && object2 instanceof String) {
            any.insert_string((String)object2);
        }
        try {
            AccessibleContext accessibleContext = null;
            if (object instanceof AccessibleContext) {
                accessibleContext = (AccessibleContext)object;
            } else if (object instanceof javax.accessibility.Accessible) {
                accessibleContext = ((javax.accessibility.Accessible)object).getAccessibleContext();
            } else {
                return;
            }
            Accessible accessible = JavaBridge.getAccessibleObjectFactory().getAccessible(accessibleContext);
            Event event = new Event(string, accessible, n, n2, any);
            accessible.ref();
            AccessUtil.getRegistryObject().notifyEvent(event);
        }
        catch (Exception exception) {
            System.out.println("Error dispatching event " + string + ":" + object + "; " + exception);
        }
    }

    public static boolean dispatchDeviceEvent(DeviceEvent deviceEvent) {
        if (deviceEvent == null) {
            return false;
        }
        return AccessUtil.getRegistryObject().getDeviceEventController().notifyListenersSync(deviceEvent);
    }

    public static void dispatchFocusEvent(Object object) {
        Any any = AccessUtil.getORB().create_any();
        try {
            Object object2;
            Accessible accessible;
            AccessibleContext accessibleContext;
            if (object instanceof AccessibleContext) {
                accessibleContext = (AccessibleContext)object;
            } else if (object instanceof javax.accessibility.Accessible) {
                accessibleContext = ((javax.accessibility.Accessible)object).getAccessibleContext();
            } else {
                return;
            }
            AccessibleRole accessibleRole = null;
            accessibleRole = accessibleContext.getAccessibleRole();
            if (accessibleRole == AccessibleRole.PAGE_TAB_LIST) {
                accessible = JavaBridge.getAccessibleObjectFactory().getAccessible(accessibleContext);
                object2 = accessibleContext.getAccessibleSelection();
                if (object2 != null && object2.getAccessibleSelectionCount() > 0) {
                    javax.accessibility.Accessible accessible2 = object2.getAccessibleSelection(0);
                    if (accessible2 instanceof AccessibleContext) {
                        accessibleContext = (AccessibleContext)((Object)accessible2);
                    } else if (accessible2 instanceof javax.accessibility.Accessible) {
                        accessibleContext = accessible2.getAccessibleContext();
                    } else {
                        return;
                    }
                }
            }
            accessible = JavaBridge.getAccessibleObjectFactory().getAccessible(accessibleContext);
            object2 = new Event("focus:", accessible, 0, 0, any);
            accessible.ref();
            AccessUtil.getRegistryObject().notifyEvent((Event)object2);
        }
        catch (Exception exception) {
            System.out.println("Error dispatching focus event :" + object + ":" + exception);
        }
    }

    public static void dispatchCaretProperty(PropertyChangeEvent propertyChangeEvent) {
        int n = Integer.parseInt(propertyChangeEvent.getOldValue().toString());
        int n2 = Integer.parseInt(propertyChangeEvent.getNewValue().toString());
        JavaBridge.dispatchEvent(propertyChangeEvent.getSource(), "object:text-caret-moved", n2, n);
    }

    public static void setInitialTextSize(AccessibleContext accessibleContext, int n) {
        lastTextSizes.put(accessibleContext, new Integer(n));
    }

    public static void dispatchTextProperty(PropertyChangeEvent propertyChangeEvent) {
        try {
            Object object = propertyChangeEvent.getNewValue();
            Object object2 = propertyChangeEvent.getOldValue();
            int n = 0;
            int n2 = -1;
            String string = null;
            String string2 = "object:text-changed";
            AccessibleContext accessibleContext = null;
            Object object3 = propertyChangeEvent.getSource();
            if (object3 instanceof AccessibleContext) {
                accessibleContext = (AccessibleContext)object3;
            } else if (object3 instanceof javax.accessibility.Accessible) {
                accessibleContext = ((javax.accessibility.Accessible)object3).getAccessibleContext();
            }
            AccessibleText accessibleText = accessibleContext.getAccessibleText();
            AccessibleEditableText accessibleEditableText = accessibleContext.getAccessibleEditableText();
            if (object instanceof Integer) {
                int n3;
                Integer n4 = lastTextSizes.put(accessibleContext, new Integer(n3 = accessibleText.getCharCount()));
                int n5 = n4 == null ? 0 : n4;
                if (n3 > n5) {
                    string2 = string2 + ":insert";
                    n2 = n3 - n5;
                } else if (n3 < n5) {
                    string2 = string2 + ":delete";
                    n2 = n5 - n3;
                } else {
                    string2 = string2 + ":replace";
                }
                n = (Integer)object;
            } else if (object instanceof Integer[] || object2 instanceof Integer[]) {
                Integer[] integerArray = (Integer[])object;
                Integer[] integerArray2 = (Integer[])object2;
                if (integerArray != null && integerArray.length != 2 || integerArray != null && integerArray.length != 2) {
                    System.err.println("TEXT_CHANGED EVENT: Unexpected length of new/old values");
                }
                if (object != null && object2 == null) {
                    string2 = string2 + ":insert";
                    n = integerArray[0];
                    n2 = integerArray[1];
                } else if (object2 != null && object == null) {
                    string2 = string2 + ":delete";
                    n = integerArray2[0];
                    n2 = integerArray2[1];
                } else if (object != null && object2 != null) {
                    n = integerArray2[0];
                    n2 = integerArray2[1];
                    JavaBridge.dispatchEvent(propertyChangeEvent.getSource(), string2 + ":delete", n, n2);
                    string2 = string2 + ":insert";
                    n = integerArray[0];
                    n2 = integerArray[1];
                }
            } else if (object != null || object2 != null) {
                System.err.println("UNHANDLED TEXT_CHANGED EVENT NewValue CLASS: " + object.getClass().getName());
            }
            if (n2 != -1) {
                string = TextImpl.getText(accessibleText, accessibleEditableText, n, n + n2);
            }
            JavaBridge.dispatchEvent(propertyChangeEvent.getSource(), string2, n, n2, string);
        }
        catch (Exception exception) {
            System.out.println("caught " + exception);
            exception.printStackTrace();
        }
    }

    public static void dispatchChildProperty(PropertyChangeEvent propertyChangeEvent) {
        AccessibleRole accessibleRole;
        boolean bl = false;
        String string = "object:children-changed";
        if (propertyChangeEvent.getNewValue() != null && propertyChangeEvent.getOldValue() == null) {
            string = string + ":add";
            bl = true;
        } else if (propertyChangeEvent.getOldValue() != null && propertyChangeEvent.getNewValue() == null) {
            string = string + ":remove";
            bl = false;
        } else {
            bl = false;
        }
        if (bl && propertyChangeEvent.getSource() instanceof AccessibleContext && (accessibleRole = ((AccessibleContext)propertyChangeEvent.getSource()).getAccessibleRole()) != null && (accessibleRole == AccessibleRole.MENU_BAR || accessibleRole == AccessibleRole.POPUP_MENU || accessibleRole == AccessibleRole.MENU || accessibleRole == AccessibleRole.MENU_ITEM)) {
            JavaBridge.traverseMenus((AccessibleContext)propertyChangeEvent.getSource());
        }
        JavaBridge.dispatchEvent(propertyChangeEvent.getSource(), string, 0, 0);
    }

    public static void dispatchStateProperty(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getOldValue();
        Object object2 = propertyChangeEvent.getNewValue();
        Object object3 = propertyChangeEvent.getSource();
        StateTypeAdapter stateTypeAdapter = object != null ? new StateTypeAdapter((AccessibleState)object) : new StateTypeAdapter((AccessibleState)object2);
        String string = "object:state-changed:" + stateTypeAdapter.getName();
        JavaBridge.dispatchEvent(object3, string, stateTypeAdapter.value(), object2 != null ? 1 : 0);
    }

    private static void startAttachListener(Accessible accessible) {
        SwingUtilities.invokeLater(new AttachListenerRunnable(accessible));
    }

    private static void attachListenerRecurse(Accessible accessible) {
        if (accessible == null) {
            return;
        }
        int n = accessible.childCount();
        if (n < 200) {
            int n2 = 0;
            while (n2 < n) {
                JavaBridge.attachListenerRecurse(accessible.getChildAtIndex(n2));
                ++n2;
            }
        } else {
            return;
        }
    }

    public static boolean traverseMenus(AccessibleContext accessibleContext) {
        return JavaBridge.traverseMenus(accessibleContext, 0);
    }

    public static boolean traverseMenus(AccessibleContext accessibleContext, int n) {
        AccessibleRole accessibleRole;
        boolean bl = false;
        if (accessibleContext != null && n < 10 && (accessibleRole = accessibleContext.getAccessibleRole()) != null) {
            if (accessibleRole == AccessibleRole.MENU_BAR || accessibleRole == AccessibleRole.POPUP_MENU || accessibleRole == AccessibleRole.MENU || accessibleRole == AccessibleRole.MENU_ITEM) {
                Accessible accessible = JavaBridge.getAccessibleObjectFactory().getAccessible(accessibleContext);
                JavaBridge.startAttachListener(accessible);
                bl = true;
            } else {
                int n2 = 0;
                while (n2 < accessibleContext.getAccessibleChildrenCount()) {
                    javax.accessibility.Accessible accessible = accessibleContext.getAccessibleChild(n2);
                    if (accessible != null) {
                        JavaBridge.getAccessibleObjectFactory().getAccessible(accessible.getAccessibleContext());
                        bl = JavaBridge.traverseMenus(accessible.getAccessibleContext(), n + 1);
                        if (bl) break;
                    }
                    ++n2;
                }
            }
        }
        return bl;
    }

    public boolean registerApplication() {
        System.err.println("Registering Application.");
        try {
            this.appAccessible = new ApplicationAccessible();
            Application application = JavaBridge.getAccessibleObjectFactory().getApplication(this.appAccessible.getAccessibleContext());
            System.err.println(application);
            AccessUtil.getRegistryObject().registerApplication(application);
            System.err.println(application.name() + ":" + application.id());
            System.err.println("Just registered Application");
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public static EventQueue getEventQueue() {
        if (accessQueue == null) {
            accessQueue = new AccessQueue();
        }
        return accessQueue;
    }

    public static void exit() {
    }

    static {
        accessibleObjectFactory = new AccessibleFactory();
        globalPropertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string == "AccessibleCaret") {
                    JavaBridge.dispatchCaretProperty(propertyChangeEvent);
                } else if (string == "AccessibleText") {
                    JavaBridge.dispatchTextProperty(propertyChangeEvent);
                } else if (string == "AccessibleChild") {
                    JavaBridge.dispatchChildProperty(propertyChangeEvent);
                } else if (string == "AccessibleActiveDescendant") {
                    Object object = propertyChangeEvent.getSource();
                    AccessibleRole accessibleRole = null;
                    if (object instanceof AccessibleContext) {
                        accessibleRole = ((AccessibleContext)object).getAccessibleRole();
                    } else if (object instanceof javax.accessibility.Accessible) {
                        accessibleRole = ((javax.accessibility.Accessible)object).getAccessibleContext().getAccessibleRole();
                    }
                    if (accessibleRole != null && (accessibleRole == AccessibleRole.TABLE || accessibleRole == AccessibleRole.LIST || accessibleRole == AccessibleRole.TREE) && propertyChangeEvent.getNewValue() != null) {
                        JavaBridge.dispatchFocusEvent(propertyChangeEvent.getNewValue());
                    }
                    JavaBridge.dispatchEvent(propertyChangeEvent.getSource(), "object:active-descendant", 0, 0);
                } else if (string == "AccessibleSelection") {
                    boolean bl = false;
                    Object object = propertyChangeEvent.getSource();
                    AccessibleRole accessibleRole = null;
                    if (object instanceof AccessibleContext) {
                        accessibleRole = ((AccessibleContext)object).getAccessibleRole();
                        if (accessibleRole == AccessibleRole.TEXT) {
                            bl = true;
                        } else if (accessibleRole == AccessibleRole.MENU_BAR) {
                            JavaBridge.dispatchFocusEvent(object);
                        } else if (accessibleRole == AccessibleRole.PAGE_TAB_LIST) {
                            AccessibleSelection accessibleSelection = ((AccessibleContext)object).getAccessibleSelection();
                            if (accessibleSelection != null && accessibleSelection.getAccessibleSelectionCount() > 0) {
                                javax.accessibility.Accessible accessible = accessibleSelection.getAccessibleSelection(0);
                                JavaBridge.dispatchFocusEvent(accessible);
                            }
                        } else if (accessibleRole == AccessibleRole.TABLE) {
                            System.err.println("SELECTION_CHANGED: TABLE : Old == NULL : " + propertyChangeEvent.getOldValue());
                            System.err.println("SELECTION_CHANGED: TABLE : New == NULL : " + propertyChangeEvent.getNewValue());
                        }
                    }
                    if (bl) {
                        JavaBridge.dispatchEvent(object, "object:text-selection-changed", 0, 0);
                    } else {
                        JavaBridge.dispatchEvent(object, "object:selection-changed", 0, 0);
                    }
                } else if (string != "AccessibleVisibleData") {
                    if (string == "accessibleActionProperty") {
                        JavaBridge.dispatchEvent(propertyChangeEvent.getSource(), "object:property-change:accessible-actions", 0, 0);
                    } else if (string == "AccessibleValue") {
                        JavaBridge.dispatchEvent(propertyChangeEvent.getSource(), "object:property-change:accessible-value", 0, 0);
                    } else if (string == "AccessibleDescription") {
                        JavaBridge.dispatchEvent(propertyChangeEvent.getSource(), "object:property-change:accessible-description", 0, 0);
                    } else if (string == "AccessibleName") {
                        JavaBridge.dispatchEvent(propertyChangeEvent.getSource(), "object:property-change:accessible-name", 0, 0);
                    } else if (string == "AccessibleHypertextOffset") {
                        JavaBridge.dispatchEvent(propertyChangeEvent.getSource(), "object:property-change:accessible-hypertext-offset", 0, 0);
                    } else if (string == "accessibleTableModelChanged") {
                        JavaBridge.dispatchEvent(propertyChangeEvent.getSource(), "object:model-changed", 0, 0);
                    } else if (string == "accessibleTableCaptionChanged") {
                        JavaBridge.dispatchEvent(propertyChangeEvent.getSource(), "object:property-change:accessible-table-caption", 0, 0);
                    } else if (string == "accessibleTableSummaryChanged") {
                        JavaBridge.dispatchEvent(propertyChangeEvent.getSource(), "object:property-change:accessible-table-summary", 0, 0);
                    } else if (string == "accessibleTableColumnHeaderChanged") {
                        JavaBridge.dispatchEvent(propertyChangeEvent.getSource(), "object:property-change:accessible-table-column-header", 0, 0);
                    } else if (string == "accessibleTableColumnDescriptionChanged") {
                        JavaBridge.dispatchEvent(propertyChangeEvent.getSource(), "object:property-change:accessible-table-column-description", 0, 0);
                    } else if (string == "accessibleTableRowHeaderChanged") {
                        JavaBridge.dispatchEvent(propertyChangeEvent.getSource(), "object:property-change:accessible-table-row-header", 0, 0);
                    } else if (string == "accessibleTableRowDescriptionChanged") {
                        JavaBridge.dispatchEvent(propertyChangeEvent.getSource(), "object:property-change:accessible-table-row-description", 0, 0);
                    } else if (string == "AccessibleState") {
                        Object object = propertyChangeEvent.getNewValue();
                        if (propertyChangeEvent.getNewValue() == AccessibleState.ARMED) {
                            Object object2 = propertyChangeEvent.getSource();
                            AccessibleRole accessibleRole = null;
                            javax.accessibility.Accessible accessible = null;
                            AccessibleRole accessibleRole2 = null;
                            if (object2 instanceof AccessibleContext) {
                                accessible = ((AccessibleContext)object2).getAccessibleParent();
                                if (accessible != null) {
                                    accessibleRole2 = accessible.getAccessibleContext().getAccessibleRole();
                                }
                                accessibleRole = ((AccessibleContext)object2).getAccessibleRole();
                            } else if (object2 instanceof javax.accessibility.Accessible) {
                                accessible = ((javax.accessibility.Accessible)object2).getAccessibleContext().getAccessibleParent();
                                if (accessible != null) {
                                    accessibleRole2 = accessible.getAccessibleContext().getAccessibleRole();
                                }
                                accessibleRole = ((javax.accessibility.Accessible)object2).getAccessibleContext().getAccessibleRole();
                            }
                            if (accessibleRole != null) {
                                if (accessibleRole == AccessibleRole.MENU_ITEM || accessibleRole == AccessibleRole.MENU) {
                                    JavaBridge.dispatchFocusEvent(propertyChangeEvent.getSource());
                                } else if (accessibleRole2 != null && accessibleRole2 == AccessibleRole.MENU && (accessibleRole == AccessibleRole.CHECK_BOX || accessibleRole == AccessibleRole.RADIO_BUTTON)) {
                                    JavaBridge.dispatchFocusEvent(propertyChangeEvent.getSource());
                                }
                            }
                        } else if (propertyChangeEvent.getNewValue() == AccessibleState.SELECTED && propertyChangeEvent.getSource() instanceof AccessibleContext) {
                            AccessibleRole accessibleRole = null;
                            accessibleRole = ((AccessibleContext)propertyChangeEvent.getSource()).getAccessibleRole();
                            if (accessibleRole == AccessibleRole.MENU) {
                                JavaBridge.dispatchFocusEvent(propertyChangeEvent.getSource());
                            }
                        }
                        JavaBridge.dispatchStateProperty(propertyChangeEvent);
                    }
                }
            }
        };
        focusListener = new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                JavaBridge.dispatchFocusEvent(focusEvent.getSource());
            }

            public void focusLost(FocusEvent focusEvent) {
            }
        };
        lastTextSizes = new HashMap();
    }

    public static class AccessQueue
    extends EventQueue {
        static KeyEvent pendingKeyPress = null;

        public void dispatchEvent(AWTEvent aWTEvent) {
            if (aWTEvent instanceof KeyEvent) {
                this.filterKeyEvent((KeyEvent)aWTEvent);
            } else {
                super.dispatchEvent(aWTEvent);
            }
        }

        public void filterKeyEvent(KeyEvent keyEvent) {
            boolean bl = false;
            DeviceEvent deviceEvent = null;
            if (keyEvent.getID() == 401) {
                if (keyEvent.isActionKey()) {
                    deviceEvent = KeyEventAdapter.deviceEventFromKeyEvent(keyEvent);
                    bl = JavaBridge.dispatchDeviceEvent(deviceEvent);
                    pendingKeyPress = null;
                } else {
                    pendingKeyPress = keyEvent;
                    bl = true;
                }
            } else if (keyEvent.getID() == 400) {
                if (pendingKeyPress != null) {
                    deviceEvent = KeyEventAdapter.coalescePressAndTyped(pendingKeyPress, keyEvent);
                    if (deviceEvent == null) {
                        deviceEvent = KeyEventAdapter.deviceEventFromKeyEvent(pendingKeyPress);
                        bl = JavaBridge.dispatchDeviceEvent(deviceEvent);
                        if (!bl) {
                            super.dispatchEvent(pendingKeyPress);
                        }
                        pendingKeyPress = null;
                        deviceEvent = KeyEventAdapter.deviceEventFromKeyEvent(keyEvent);
                    }
                } else {
                    deviceEvent = KeyEventAdapter.deviceEventFromKeyEvent(keyEvent);
                }
                if (bl = JavaBridge.dispatchDeviceEvent(deviceEvent)) {
                    pendingKeyPress = null;
                }
            }
            if (!bl) {
                if (pendingKeyPress != null) {
                    super.dispatchEvent(pendingKeyPress);
                    pendingKeyPress = null;
                }
                super.dispatchEvent(keyEvent);
            }
        }
    }

    private static class AttachListenerRunnable
    implements Runnable {
        private Accessible accessible;

        public AttachListenerRunnable(Accessible accessible) {
            this.accessible = accessible;
        }

        public void run() {
            try {
                JavaBridge.attachListenerRecurse(this.accessible);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

