!> \mainpage Spyro Link Library (SPYROLINK)
!>
!> SPYRO\latexonly\textregistered{}\endlatexonly\htmlonly (R)\endhtmlonly Suite 7 - SPYROLINK\n\n
!> Application Program Interface for the SPYROLINK module\n
!>
!>
!> \brief Defines the interfaces to link to the SPYRO Suite via a third party interface.
!> \note
!> This module defines the procedures to simulate SPYRO
!> \latexonly\textregistered{}\endlatexonly\htmlonly (R)\endhtmlonly Suite 7 cases via a 
!> third party interface. The main calling sequence would be first to initialize a 
!> case ("Initialise"), retrieving the input information and 
!> their values ("GetInputInformation") that can be manipulated 
!> via the third party interface. Thereafter a simulation can be executed 
!> ("Simulate") which 
!> return the output values. A separate routine is provided to get string 
!> information ("GetOutputInformation") on the 
!> particular outputs. When an error occurred one can retrieve 
!> the last error string as well. \n\n
!> The SPYRO\latexonly\textregistered{}\endlatexonly\htmlonly (R)\endhtmlonly 
!> Suite 7 GUI is the configuration tool for a particular case 
!> that needs to be solved via the third party interface. Currently one can 
!> only manipulated the input values that are fixed of the FEED and the PRODUCT 
!> models within a case. When a certain case is changed via the GUI this case 
!> needs to be (re-)initialized via the third party program. This will results 
!> in reinitialized input and output entities. \n\n
!> The SPYROLINK module is capable of handle multiple initialized cases. 
!> The simulation of the initialized cases is done sequentially, meaning that 
!> other case can be simulated when the current simulated case is finalized. 
!> \author MWMG
!> \date Tuesday, 24 January 2010
!> 
!>
!>  
MODULE SpyroLink !{
!*****************************************************************************
!** EXTERNAL MODULE
!** NO IMPLICIT DECLARATIONS
IMPLICIT NONE
!** CONTAINS
PRIVATE
PUBLIC  ::pySL_Initialise
PRIVATE ::GetCaseSequenceByName
  
!
!** GLOBAL VARIABLES WITHIN THIS MODULE

!> \details The length of all the strings used, like is defined for a "File Name".
INTEGER,PARAMETER           :: StringLength                = 1025
!> \details The size of  "Iarray".
INTEGER,PARAMETER           :: LenSizeInfo                 = 20

!> \cond DEVELOPER_MANUAL

CHARACTER(Len=*), PARAMETER :: MdlName = 'SpyroLink'

TYPE CaseStructureType
  INTEGER                       ::CaseID           = 0      ! The CaseID of the case
  LOGICAL                       ::OutputMode       =.false. ! Operate in the output mode
  CHARACTER(len=StringLength)   ::FileDirName      = ''     ! The filename including directory
  CHARACTER(len=StringLength)   ::FileDirName0Free = ''     ! The filename including directory with out terminating null
  INTEGER,DIMENSION(LenSizeInfo)::SizeInfo         = 0      ! The Size Info, all kind of length required for checking
ENDTYPE CaseStructureType


TYPE(CaseStructureType),DIMENSION(:),POINTER :: pySL_CasesAvailable=>null()

CHARACTER(len=StringLength) :: pySL_LastError              = ''
CHARACTER(len=StringLength) :: String                      = ''
LOGICAL                     :: pySL_GenerateResults        =.true.
LOGICAL                     :: pySL_IsInitialised          =.false.
INTEGER                     :: pySL_CaseID4SL              = 0
! ****************************************************************************
!> \endcond

!> \details location in the \ref anchorIarray "Iarray" for the number of outputs
INTEGER,PARAMETER ::SequenceNumOutput = 1  ! Number of outputs

!> \details location in the \ref anchorIarray "Iarray" for the number of inputs
INTEGER,PARAMETER ::SequenceNumInput = 2  ! Number of inputs

!> \cond DEVELOPER_MANUAL
INTEGER,PARAMETER ::Glob_nO = SequenceNumOutput ! Number of outputs
INTEGER,PARAMETER ::Glob_nI = SequenceNumInput  ! Number of inputs
!> \endcond 
!
! ****************************************************************************
CONTAINS

 
  !> \anchor anchorInitialise
  !> \brief Initialise a case
  !> \author MWMG
  !> \date Wednesday, 23 July 2008
  !> \details When the OS7.DLL is not initialised this DLL will also be initialised.
  !> \remarks cdecl calling convention is used
  !> \anchor anchorFileName
  !> \param FileDirName The file name including directory (null terminated!)
  !> \param OutputMode Must this case be initialised with the output mode (1=YES)
  !> \param CaseID The identifier of this case, to be used for other functionality
  !> \anchor anchorIarray
  !> \param Iarray Integer array with all kinds of information handy for the user.
  !> \return RetVal The return status:\n
  !>         - 1 All went OKE
  FUNCTION pySL_Initialise  (FileDirName, OutputMode, CaseID, Iarray) RESULT(RetVal) !{
  !DEC$ ATTRIBUTES C, DLLEXPORT, ALIAS: 'PYSL_INITIALISE' :: pySL_Initialise
  !DEC$ ATTRIBUTES REFERENCE                              :: FileDirName
  !DEC$ ATTRIBUTES REFERENCE                              :: OutputMode
  !DEC$ ATTRIBUTES REFERENCE                              :: CaseID
  !DEC$ ATTRIBUTES REFERENCE                              :: Iarray
  !***************************************************************************
  !** EXTERNAL MODULE VARIABLES
  !** CALLED ROUTINES FROM EXTERNAL MODULES
  USE UTIL,           ONLY: Transl, &
                            Num2String, &
                            NullTermStr2FortranStr
  !** NO IMPLICIT DECLARATIONS
  IMPLICIT NONE
  !** HEADER VARIABLES/ARGUMENTS
  CHARACTER(len=StringLength),    INTENT(IN)  :: FileDirName 
  INTEGER,                        INTENT(IN)  :: OutputMode  
  INTEGER,                        INTENT(OUT) :: CaseID      
  INTEGER,DIMENSION(LenSizeInfo), INTENT(OUT) :: Iarray      
  !** RETURN VARIABLE
  INTEGER :: RetVal
  !***************************************************************************
    !** LOCAL VARIABLES

  ENDFUNCTION pySL_Initialise !}

  
  !> \brief Gets the Case sequence number
  !> \author MWMG
  !> \date Monday, 05 October 2009
  !> \remarks When failed zero is returned
  !> \return CaseSeq in description of the return variable ASAP!!!
  FUNCTION GetCaseSequenceByName(FileDirName) RESULT(CaseSeq)!{
  !***************************************************************************
  !** EXTERNAL MODULE VARIABLES
  !** CALLED ROUTINES FROM EXTERNAL MODULES
  USE UTIL,           ONLY: NullTermStr2FortranStr
  !** NO IMPLICIT DECLARATIONS
  IMPLICIT NONE
  !** HEADER VARIABLES/ARGUMENTS
  CHARACTER(len=*),INTENT(IN)::FileDirName
  !** RETURN VARIABLE
  INTEGER ::CaseSeq
  !***************************************************************************
    !** LOCAL VARIABLES
    INTEGER ::i
    CHARACTER(len=len(FileDirName))::Name
    !*************************************************************************
    CaseSeq=0
    ! First remove the null stuff 
    Name=FileDirName
    CALL NullTermStr2FortranStr(Name)
    IF (associated(pySL_CasesAvailable).and.(len_trim(Name)/=0)) THEN
      DO i=1,size(pySL_CasesAvailable)
        IF (trim(pySL_CasesAvailable(i)%FileDirName0Free)==trim(Name)) THEN
          CaseSeq=i
          EXIT
        ENDIF
      ENDDO
    ENDIF
  ENDFUNCTION GetCaseSequenceByName !}        


ENDMODULE SpyroLink !}


