/**
 * \file file2.cpp
 *
 * define an other version of dump
 */

/// Some structure
struct Employe
{
  int     id; 
  string  name;
};

#if defined(DEBUG) || defined(DOXYGEN_MAKE) 
/**
 * \brief Dump an instance of Employe
 *
 * \param p The empoyee instance to dump
 */
#   define DUMP(p) printf("[%d] %s\n", p->id, p->name.c_str())
#else
#   define DUMP(p) 
#endif //!DEBUG 


#if defined(DEBUG) || defined(DOXYGEN_MAKE) 
/**
 * \brief Dump a list of Employe
 *
 * \param p The list
 */
#   define DUMP_LIST(p) \
          for(list<Employe> it(p.begin()), itEnd(p.end(); \
              it != itEnd;                                \
              ++it)                                       \
              DUMP(*it);
#else
#   define DUMP_LIST(p) 
#endif //!DEBUG 
