/**
 * @file device.h
 * @author AJ Visser, (C) 2009-2010
 * @date Created @ 08-01-2010
 * @date Last Modified @ 18-01-2010
 */

#ifndef _H_DEVICE_H_
#define _H_DEVICE_H_

#include "../include/defines/return.h"
#include "../include/defines/status.h"
#include "../include/idevice.h"
#include "../include/subject.h"
#include "../include/thread.h"
/**
 * @class Device
 * @brief Skeleton class for other devices.
 */

class Device : public IDevice, public Subject , public Thread {
	private:
		STATUS m_sStatus;	/*!< Status of device objects. */

	protected:
		Device();
		RESULT SetStatus(STATUS sStatus);

	public:
		virtual ~Device();
		RESULT GetStatus(STATUS *psStatus);
};

#endif
