/*
 * Decompiled with CFR 0.152.
 */
package org.GNOME.Accessibility;

import java.util.Locale;
import javax.accessibility.AccessibleState;
import org.GNOME.Accessibility.StateType;

public class StateTypeAdapter
extends StateType {
    AccessibleState state;

    public StateTypeAdapter(AccessibleState accessibleState) {
        super(StateTypeAdapter.valueFromAccessibleState(accessibleState));
        this.state = accessibleState;
    }

    public String getName() {
        return this.state.toDisplayString(Locale.US);
    }

    static AccessibleState accessibleStateFromStateType(StateType stateType) {
        AccessibleState accessibleState = null;
        switch (stateType.value()) {
            case 1: {
                accessibleState = AccessibleState.ACTIVE;
                break;
            }
            case 2: {
                accessibleState = AccessibleState.ARMED;
                break;
            }
            case 3: {
                accessibleState = AccessibleState.BUSY;
                break;
            }
            case 4: {
                accessibleState = AccessibleState.CHECKED;
                break;
            }
            case 5: {
                accessibleState = AccessibleState.COLLAPSED;
                break;
            }
            case 7: {
                accessibleState = AccessibleState.EDITABLE;
                break;
            }
            case 8: {
                accessibleState = AccessibleState.ENABLED;
                break;
            }
            case 9: {
                accessibleState = AccessibleState.EXPANDABLE;
                break;
            }
            case 10: {
                accessibleState = AccessibleState.EXPANDED;
                break;
            }
            case 11: {
                accessibleState = AccessibleState.FOCUSABLE;
                break;
            }
            case 12: {
                accessibleState = AccessibleState.FOCUSED;
                break;
            }
            case 14: {
                accessibleState = AccessibleState.HORIZONTAL;
                break;
            }
            case 15: {
                accessibleState = AccessibleState.ICONIFIED;
                break;
            }
            case 16: {
                accessibleState = AccessibleState.MODAL;
                break;
            }
            case 17: {
                accessibleState = AccessibleState.MULTI_LINE;
                break;
            }
            case 18: {
                accessibleState = AccessibleState.MULTISELECTABLE;
                break;
            }
            case 19: {
                accessibleState = AccessibleState.OPAQUE;
                break;
            }
            case 20: {
                accessibleState = AccessibleState.PRESSED;
                break;
            }
            case 21: {
                accessibleState = AccessibleState.RESIZABLE;
                break;
            }
            case 22: {
                accessibleState = AccessibleState.SELECTABLE;
                break;
            }
            case 23: {
                accessibleState = AccessibleState.SELECTED;
                break;
            }
            case 25: {
                accessibleState = AccessibleState.SHOWING;
                break;
            }
            case 26: {
                accessibleState = AccessibleState.SINGLE_LINE;
                break;
            }
            case 28: {
                accessibleState = AccessibleState.TRANSIENT;
                break;
            }
            case 29: {
                accessibleState = AccessibleState.VERTICAL;
                break;
            }
            case 30: {
                accessibleState = AccessibleState.VISIBLE;
            }
        }
        return accessibleState;
    }

    static int valueFromAccessibleState(AccessibleState accessibleState) {
        int n = 0;
        n = accessibleState == AccessibleState.ACTIVE ? 1 : (accessibleState == AccessibleState.ARMED ? 2 : (accessibleState == AccessibleState.BUSY ? 3 : (accessibleState == AccessibleState.CHECKED ? 4 : (accessibleState == AccessibleState.COLLAPSED ? 5 : (accessibleState == AccessibleState.EDITABLE ? 7 : (accessibleState == AccessibleState.ENABLED ? 8 : (accessibleState == AccessibleState.EXPANDABLE ? 9 : (accessibleState == AccessibleState.EXPANDED ? 10 : (accessibleState == AccessibleState.FOCUSABLE ? 11 : (accessibleState == AccessibleState.FOCUSED ? 12 : (accessibleState == AccessibleState.HORIZONTAL ? 14 : (accessibleState == AccessibleState.ICONIFIED ? 15 : (accessibleState == AccessibleState.MODAL ? 16 : (accessibleState == AccessibleState.MULTI_LINE ? 17 : (accessibleState == AccessibleState.MULTISELECTABLE ? 18 : (accessibleState == AccessibleState.OPAQUE ? 19 : (accessibleState == AccessibleState.PRESSED ? 20 : (accessibleState == AccessibleState.RESIZABLE ? 21 : (accessibleState == AccessibleState.SELECTABLE ? 22 : (accessibleState == AccessibleState.SELECTED ? 23 : (accessibleState == AccessibleState.SHOWING ? 25 : (accessibleState == AccessibleState.SINGLE_LINE ? 26 : (accessibleState == AccessibleState.TRANSIENT ? 28 : (accessibleState == AccessibleState.VERTICAL ? 29 : (accessibleState == AccessibleState.VISIBLE ? 30 : (accessibleState.toString() == "managesDescendants" ? 31 : 0))))))))))))))))))))))))));
        return n;
    }
}

