/*
 * Decompiled with CFR 0.152.
 */
package org.GNOME.Accessibility;

import java.awt.event.KeyEvent;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleExtendedComponent;
import javax.accessibility.AccessibleKeyBinding;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.GNOME.Accessibility.ActionOperations;
import org.GNOME.Accessibility.ActionPOATie;
import org.GNOME.Accessibility.JavaBridge;
import org.GNOME.Bonobo.UnknownImpl;

public class ActionImpl
extends UnknownImpl
implements ActionOperations {
    private AccessibleAction accAction;
    private AccessibleExtendedComponent accExComponent;

    public ActionImpl(AccessibleContext accessibleContext) {
        this.accAction = accessibleContext.getAccessibleAction();
        if (accessibleContext.getAccessibleComponent() instanceof AccessibleExtendedComponent) {
            this.accExComponent = (AccessibleExtendedComponent)accessibleContext.getAccessibleComponent();
        }
        this.poa = JavaBridge.getRootPOA();
        this.tie = new ActionPOATie(this, JavaBridge.getRootPOA());
        try {
            JavaBridge.getRootPOA().activate_object(this.tie);
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    public int nActions() {
        int n = 0;
        if (this.accAction != null) {
            n = this.accAction.getAccessibleActionCount();
        }
        return n;
    }

    public String getDescription(int n) {
        String string = "<description>";
        return string;
    }

    public String getName(int n) {
        String string;
        if (this.accAction != null && (string = this.accAction.getAccessibleActionDescription(n)) != null) {
            return string;
        }
        return " ";
    }

    public boolean doAction(int n) {
        try {
            if (this.accAction != null) {
                SwingUtilities.invokeLater(new ActionRunner(this.accAction, n));
                return true;
            }
        }
        catch (Exception exception) {
            System.err.println("Exception : " + exception.toString());
        }
        return false;
    }

    private String convertModString(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        String[] stringArray = string.split("\\+");
        String string2 = "";
        int n = 0;
        while (n < stringArray.length) {
            string2 = string2 + "<" + stringArray[n] + ">";
            ++n;
        }
        return string2;
    }

    public String getKeyBinding(int n) {
        AccessibleKeyBinding accessibleKeyBinding;
        if (n > 0) {
            return "";
        }
        if (this.accExComponent != null && (accessibleKeyBinding = this.accExComponent.getAccessibleKeyBinding()) != null && accessibleKeyBinding.getAccessibleKeyBindingCount() >= 0) {
            String string = "";
            int n2 = 0;
            while (n2 < accessibleKeyBinding.getAccessibleKeyBindingCount() && n2 < 3) {
                String string2;
                KeyStroke[] keyStrokeArray;
                Object object = accessibleKeyBinding.getAccessibleKeyBinding(n2);
                if (n2 > 0) {
                    string = string + ";";
                }
                if (object instanceof KeyStroke) {
                    keyStrokeArray = (KeyStroke[])object;
                    String string3 = KeyEvent.getKeyModifiersText(keyStrokeArray.getModifiers());
                    string2 = KeyEvent.getKeyText(keyStrokeArray.getKeyCode());
                    if (string2 != null) {
                        string = string3 != null && string3.length() > 0 ? string + this.convertModString(string3) + string2 : string + string2;
                    }
                } else if (object instanceof KeyStroke[]) {
                    keyStrokeArray = (KeyStroke[])object;
                    int n3 = 0;
                    while (n3 < keyStrokeArray.length) {
                        string2 = KeyEvent.getKeyModifiersText(keyStrokeArray[n3].getModifiers());
                        String string4 = KeyEvent.getKeyText(keyStrokeArray[n3].getKeyCode());
                        if (string4 != null) {
                            string = string2 != null && string2.length() > 0 ? string + this.convertModString(string2) + string4 : string + string4;
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
            if (n2 < 2) {
                string = string + ";";
            }
            if (n2 < 3) {
                string = string + ";";
            }
            return string;
        }
        return "";
    }

    public void unImplemented() {
    }

    public void unImplemented2() {
    }

    public void unImplemented3() {
    }

    public void unImplemented4() {
    }

    private class ActionRunner
    implements Runnable {
        private AccessibleAction accAction;
        private int index;

        public ActionRunner(AccessibleAction accessibleAction, int n) {
            this.accAction = accessibleAction;
            this.index = n;
        }

        public void run() {
            this.accAction.doAccessibleAction(this.index);
        }
    }
}

