/*
 * Decompiled with CFR 0.152.
 */
package org.GNOME.Accessibility;

import java.awt.AWTEvent;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import org.GNOME.Accessibility.JavaBridge;

public class ApplicationAccessible
implements Accessible {
    AccessibleContext accContext = new AccessibleAppContext();

    public AccessibleContext getAccessibleContext() {
        return this.accContext;
    }

    public class AccessibleAppContext
    extends AccessibleContext {
        List vtoplevels = Collections.synchronizedList(new LinkedList());
        final WindowListener l = new WindowAdapter(this){
            private final /* synthetic */ AccessibleAppContext this$1;
            {
                this.this$1 = accessibleAppContext;
            }

            public void windowActivated(WindowEvent windowEvent) {
                JavaBridge.dispatchWindowEvent(windowEvent.getSource(), "window:activate");
            }

            public void windowStateChanged(WindowEvent windowEvent) {
                JavaBridge.dispatchWindowEvent(windowEvent.getSource(), "object:state-changed");
            }

            public void windowDeiconifed(WindowEvent windowEvent) {
                JavaBridge.dispatchWindowEvent(windowEvent.getSource(), "window:restore");
            }

            public void windowIconifieded(WindowEvent windowEvent) {
                JavaBridge.dispatchWindowEvent(windowEvent.getSource(), "window:minimize");
            }

            public void windowDeactivated(WindowEvent windowEvent) {
                JavaBridge.dispatchWindowEvent(windowEvent.getSource(), "window:deactivate");
            }

            public void windowClosed(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                if (AccessibleAppContext.access$000(this.this$1, window)) {
                    this.this$1.vtoplevels.remove(window);
                }
                JavaBridge.dispatchWindowEvent(windowEvent.getSource(), "window:destroy");
                JavaBridge.dispatchEvent(AccessibleAppContext.access$100(this.this$1).getAccessibleContext(), "object:children-changed:remove", 0, 0);
                if (AccessibleAppContext.access$200(this.this$1) == 0) {
                    JavaBridge.exit();
                }
            }

            public void windowOpened(WindowEvent windowEvent) {
                Window window = windowEvent.getWindow();
                if (AccessibleAppContext.access$000(this.this$1, window)) {
                    if (!this.this$1.vtoplevels.contains(window)) {
                        this.this$1.vtoplevels.add(window);
                    }
                } else {
                    System.out.println("WARNING: Unhandled Window type : " + window.toString());
                }
                JavaBridge.dispatchWindowEvent(windowEvent.getSource(), "window:create");
                if (windowEvent.getSource() instanceof Accessible) {
                    JavaBridge.traverseMenus(((Accessible)windowEvent.getSource()).getAccessibleContext());
                }
                JavaBridge.dispatchEvent(AccessibleAppContext.access$100(this.this$1).getAccessibleContext(), "object:children-changed:add", 0, 0);
            }
        };
        AWTEventListener globalListener = new AWTEventListener(this){
            private final /* synthetic */ AccessibleAppContext this$1;
            {
                this.this$1 = accessibleAppContext;
            }

            public void eventDispatched(AWTEvent aWTEvent) {
                if (aWTEvent instanceof WindowEvent) {
                    switch (aWTEvent.getID()) {
                        case 200: {
                            ((WindowEvent)aWTEvent).getWindow().addWindowListener(this.this$1.l);
                            break;
                        }
                    }
                } else if (aWTEvent instanceof FocusEvent) {
                    switch (aWTEvent.getID()) {
                        case 1004: {
                            JavaBridge.dispatchFocusEvent(aWTEvent.getSource());
                            break;
                        }
                    }
                }
            }
        };
        Toolkit toolkit = Toolkit.getDefaultToolkit();

        private int toplevelCount() {
            return this.vtoplevels.size();
        }

        private boolean isToplevel(Object object) {
            return object instanceof Window || object instanceof Frame || object instanceof Dialog;
        }

        public AccessibleAppContext() {
            this.toolkit.addAWTEventListener(this.globalListener, 68L);
            this.toolkit.getSystemEventQueue().push(JavaBridge.getEventQueue());
        }

        public Locale getLocale() {
            return null;
        }

        public Accessible getAccessibleChild(int n) {
            Accessible accessible = null;
            if (n < this.toplevelCount()) {
                accessible = (Accessible)this.vtoplevels.get(n);
                accessible.getAccessibleContext().setAccessibleParent(ApplicationAccessible.this);
            }
            return accessible;
        }

        public Accessible getAccessibleParent() {
            return null;
        }

        public int getAccessibleChildrenCount() {
            return this.toplevelCount();
        }

        public int getAccessibleIndexInParent() {
            return -1;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            return new AccessibleStateSet();
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.UNKNOWN;
        }

        public String getAccessibleName() {
            String string = null;
            if (this.toplevelCount() > 0) {
                int n = 0;
                while (n < this.getAccessibleChildrenCount()) {
                    String string2;
                    Accessible accessible = this.getAccessibleChild(n);
                    if (accessible != null && (string2 = accessible.getAccessibleContext().getAccessibleName()) != null && string2.length() != 0) {
                        string = string2;
                        break;
                    }
                    ++n;
                }
            }
            if (string == null) {
                string = "Java Application";
            }
            return string;
        }

        public String getAccessibleDescription() {
            return "an accessible Java app";
        }

        static /* synthetic */ boolean access$000(AccessibleAppContext accessibleAppContext, Object object) {
            return accessibleAppContext.isToplevel(object);
        }

        static /* synthetic */ ApplicationAccessible access$100(AccessibleAppContext accessibleAppContext) {
            return accessibleAppContext.ApplicationAccessible.this;
        }

        static /* synthetic */ int access$200(AccessibleAppContext accessibleAppContext) {
            return accessibleAppContext.toplevelCount();
        }
    }
}

