#ifndef _CPATHNAME_HPP_
#define _CPATHNAME_HPP_

#include <string>

//////////////////////////////////////////////////////////////////////////////////////////////////////////////
///	@headerfile cpathname.hpp "cpathname.hpp"
///	@brief Represents a path name.
//////////////////////////////////////////////////////////////////////////////////////////////////////////////
class CPathName
{
public:
	// Constructors/destructor
	CPathName(const char* apPathName);
	CPathName(const std::string& arPathName);
	~CPathName() throw();

	// Copy/assignment
	CPathName(const CPathName& arRHS);
	CPathName& operator=(const CPathName& arRHS);
	void swap(CPathName& arRHS) throw();

	// Instance setters/getters
	const char* mpGetPathName() const;

private:
	// Instance data
	std::string mvPathName;
};

void swap(CPathName& arLHS, CPathName& arRHS) throw();

#endif // _CPATHNAME_HPP_
