#include <algorithm>

#include "cpathname.hpp"

using namespace std;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////
///	@brief Creates a CPathName object.
///
///	@param[in]	apPathName	The name of a path.
//////////////////////////////////////////////////////////////////////////////////////////////////////////////
CPathName::CPathName(const char* apPathName)
try	:	mvPathName(apPathName ? apPathName : "")					// Possible std::bad_alloc here.
{
}
catch (bad_alloc&)
{
	throw;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////
///	@brief Creates a CPathName object.
///
///	@param[in]	arPathName	The name of a path.
//////////////////////////////////////////////////////////////////////////////////////////////////////////////
CPathName::CPathName(const string& arPathName)
try	:	mvPathName(arPathName)										// Possible std::bad_alloc here.
{
}
catch (bad_alloc&)
{
	throw;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////
///	@brief Destroys a CPathName object.
//////////////////////////////////////////////////////////////////////////////////////////////////////////////
CPathName::~CPathName() throw()
{
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////
///	@brief Copies a CPathName object.
///
///	@param[in]	arRHS	The CPathName object to be copied.
//////////////////////////////////////////////////////////////////////////////////////////////////////////////
CPathName::CPathName(const CPathName& arRHS)
try	:	mvPathName(arRHS.mvPathName)								// Possible std::bad_alloc here.
{
}
catch (bad_alloc&)
{
	throw;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////
///	@brief Assigns a CPathName object to another CPathName object.
///
///	@param[in]	arRHS	The CPathName object to assign to another CPathName object.
///
///	@return	The CPathName object assigned to.
//////////////////////////////////////////////////////////////////////////////////////////////////////////////
CPathName& CPathName::operator=(const CPathName& arRHS)
{
	try
	{
		CPathName vCopy(arRHS);										// Possible std::bad_alloc here.
		swap(vCopy);
		return *this;
	}
	catch (bad_alloc&)
	{
		throw;
	}
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////
///	@brief Swaps a CPathName object with another CPathName object.
///
///	@param[in,out]	arRHS	The CPathName object to swap with.
//////////////////////////////////////////////////////////////////////////////////////////////////////////////
void CPathName::swap(CPathName& arRHS) throw()
{
	using std::swap;
	swap(mvPathName, arRHS.mvPathName);
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////
///	@brief Obtains the name of a path.
///
///	@return The name of a path.
//////////////////////////////////////////////////////////////////////////////////////////////////////////////
const char* CPathName::mpGetPathName() const
{
	try
	{
		return mvPathName.c_str();									// Possible std::bad_alloc here.
	}
	catch (bad_alloc&)
	{
		return "";
	}
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////
///	@brief Overloads std::swap for CPathName objects.
///
///	@param[in,out]	arLHS	The first object to swap.
///	@param[in,out]	arRHS	The second object to swap.
//////////////////////////////////////////////////////////////////////////////////////////////////////////////
void swap(CPathName& arLHS, CPathName& arRHS) throw()
{
	arLHS.swap(arRHS);
}
