#ifndef QGLRENDERER_H
#define QGLRENDERER_H

#include <QGLWidget>
#include "GstGLBufferDef.h"


class GstThread;

class QGLRenderer : public QGLWidget
{
  Q_OBJECT

public:
  QGLRenderer(const QString &videoLocation, QWidget *parent = 0);
  ~QGLRenderer();

	void closeEvent (QCloseEvent* event);

Q_SIGNALS:
  void closeRequested();

public Q_SLOTS:
	void newFrame();

protected:
	virtual void initializeGL();
	virtual void resizeGL(int width, int height);
	virtual void paintGL();

private:
	QString videoLoc;
  GstThread *gst_thread;
  bool closing;
	GstGLBuffer *frame;
};

#endif // QGLRENDERER_H
