// compile with gcc -Wall -g hiddentest.c -o test `pkg-config --cflags gtk+-2.0 --libs gtk+-2.0`  -export-dynamic


#include <gtk/gtk.h>

void on_window_destroy(GtkObject *object, gpointer user_data);
void on_menu_open(GtkObject *object, gpointer user_data);
void on_menu_quit(GtkObject *object, gpointer user_data);
void pretty_colour (GtkTextBuffer * buffer);
void error_message (const gchar *message);


// pointers to the main objects
GtkBuilder		*builder;
GtkWidget 		*window;
GtkWidget			*textview;
GtkTextBuffer	*textbuffer;

int main (int argc, char * argv[])
{
	// initialise everything
	gtk_init (&argc, &argv);
	
	// build the gui from the xml file
	builder = gtk_builder_new();
	gtk_builder_add_from_file (builder, "hiddentest.xml", NULL);
	
	// join it all together
	window = GTK_WIDGET (gtk_builder_get_object(builder,"window"));
	// we need to know about the text buffer and text view
	textview = GTK_WIDGET (gtk_builder_get_object (builder,"text_view"));
	textbuffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW (textview));

	// then we can connect all the signals - we need to have got the references first
	gtk_builder_connect_signals (builder,NULL);
	g_object_unref(G_OBJECT (builder));
	
	// set the title and a sensible size
	gtk_window_resize (GTK_WINDOW (window), 800, 600);
	
	// show it, and off we go
	gtk_widget_show (window);
	gtk_main();
	
	return 0;
}

void on_window_destroy(GtkObject *object, gpointer user_data)
{
	gtk_main_quit();
}

void on_menu_quit(GtkObject *object, gpointer user_data)
{
	gtk_main_quit();
}


void on_menu_open(GtkObject *object, gpointer user_data)
{
	// when we click open, we do the file-open dialog
	// and load the file into the buffer

gchar				*filename = NULL;
GtkWidget		*chooser;
GError			*err=NULL;
gchar				*text;
gboolean		result;

 // file selection dialog
 chooser = gtk_file_chooser_dialog_new ("Open File...",
                                         GTK_WINDOW (window),
                                         GTK_FILE_CHOOSER_ACTION_OPEN,
                                         GTK_STOCK_CANCEL, 
                                         GTK_RESPONSE_CANCEL,
                                         GTK_STOCK_OPEN, 
                                         GTK_RESPONSE_OK,
                                         NULL);
                                         
  if (gtk_dialog_run (GTK_DIALOG (chooser)) == GTK_RESPONSE_OK)
  {
		// get the filename, if we picked one
		filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (chooser));
  }
  
  gtk_widget_destroy (chooser);
  if (filename != NULL) 
  {
  	// if we selected something	
		result = g_file_get_contents (filename, &text, NULL, &err);
		if (result == FALSE)
		{
	    // error loading file, show message to user 
	    error_message (err->message);
	    g_error_free (err);
	    g_free (filename);
		}
		else
		{
			// okay, something to see
			// turn off the screen a moment while we load it
			gtk_widget_set_sensitive (textview, FALSE);
			gtk_text_buffer_set_text (textbuffer, text, -1);
			gtk_text_buffer_set_modified (textbuffer, FALSE);
			pretty_colour(textbuffer);
			gtk_widget_set_sensitive (textview, TRUE);
			g_free (text); 
		}
	}
}

void pretty_colour (GtkTextBuffer * buffer)
{
	// we'll need some iterators
	
GtkTextIter start;
GtkTextIter end;
GtkTextIter iter;
GtkTextIter block_start;
GtkTextIter block_end;


	// and a few text tags
GtkTextTagTable * tag_table;	

	// create them only if they don't already exist
 	tag_table = gtk_text_buffer_get_tag_table (buffer);
 
  // invisible
  if (gtk_text_tag_table_lookup (tag_table, "invisible") == NULL)
		gtk_text_buffer_create_tag (buffer, 
																"invisible", 
		                            "invisible", TRUE,
		                            NULL);
	 
	// set selected words in <options> tags blue and hide the tags and other options
	// this is a bit more complicated
	// set the limits for the search
	gtk_text_buffer_get_bounds (buffer, &start, &end);

	// search for the block start - <options>
	while (gtk_text_iter_forward_search(&start, "<options>", 0, &block_start, &iter, &end))
	{	
		// make sure there's a matching end tag
		if (gtk_text_iter_forward_search(&start, "</options>", 0, &iter, &block_end, &end))
		{
			gtk_text_buffer_apply_tag_by_name (buffer, "invisible", &block_start, &block_end);
			// move the start of the search for the next one
			start = block_end;
		}
		else
			break;
	}
}

void error_message (const gchar * message)
{
GtkWidget *dialog;

	// log to terminal window 
	g_warning ("%s",message);

	// create an error message dialog and display modally to the user 
	dialog = gtk_message_dialog_new (NULL, 
		                               GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
		                               GTK_MESSAGE_ERROR,
		                               GTK_BUTTONS_OK,
		                               "%s",message);

	gtk_window_set_title (GTK_WINDOW (dialog), "Error!");
	gtk_dialog_run (GTK_DIALOG (dialog));      
	gtk_widget_destroy (dialog);         
}

