//*****************************************************************************
//*****                            UNCLASSIFIED                           *****
//*****************************************************************************
/**
* @file
* Declaration of the class SetCaptureThreadChannel.
*/

#pragma once

#include "Rc/Types.h"
#include "Rc/Tgp/HelperThreads/Requests/HelperThreadRequest.h"
#include "Rc/Tgp/HelperThreads/CaptureThread/CaptureThreadChannel.h"

namespace Rc
{
   namespace Tgp
   {
      namespace HelperThreads
      {
         /** This class represents a request to the CaptureThread for changing the video 
         * capture channel.
         */
         class SetCaptureThreadChannel : public Rc::Tgp::HelperThreads::HelperThreadRequest
         {

         public:
            /** Friend stream insertion operator.
            * @return Output stream.
            * @param out Output stream to insert into.
            * @param rhs Right hand side to be inserted.
            */
            friend std::ostream& operator<< (std::ostream& out, Rc::Tgp::HelperThreads::SetCaptureThreadChannel& rhs);

            /** Constructor. 
            * @param channel Video channel to capture. 
            * @param helperThread Pointer to the helper thread that this request is for.
            */
            SetCaptureThreadChannel (const Rc::Tgp::HelperThreads::CaptureThreadChannel channel = Rc::Tgp::HelperThreads::CaptureThreadChannel::e_flir, 
               Rc::Exec::HelperThread* helperThread = 0);

            /** Copy constructor.
            * @param request Source object.
            */
            SetCaptureThreadChannel (const SetCaptureThreadChannel& request);

            /** Destructor. */
            virtual ~SetCaptureThreadChannel();

            /** Serialize the request. Packs the data members into a byte buffer so that it can be transmitted
            * or copied.
            */
            virtual void serialize ();

            /** Deserializes the request, extracting data from the buffer into the data members. */
            virtual void deserialize();

            /** This function is called by a request queue as part of request processing. 
            */
            virtual void execute();

         protected:
            /** Video capture channel being requested. */
            Rc::Tgp::HelperThreads::CaptureThreadChannel m_channel;
         };
      }
   }
}
