/* -*-c++-*- OpenSceneGraph - Copyright (C) 1998-2008 Robert Osfield 
 *
 * This library is open source and may be redistributed and/or modified under  
 * the terms of the OpenSceneGraph Public License (OSGPL) version 0.0 or 
 * (at your option) any later version.  The full license is in LICENSE file
 * included with this distribution, and on the openscenegraph.org website.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * OpenSceneGraph Public License for more details.
 */

/*!
 * \file mainpage.h
 *
 * This file contains doxygen special commands and text for the 
 * \ref main "Main Page" and some other minor aspects of this documentation.
 * It is not part of the OSG.
 */

/*!
 * \mainpage
 * 
 * \image html banner_osg_small.jpg
 *
 * The <a href="http://www.openscenegraph.org/">OpenSceneGraph</a> exists as
 * a number of modules, each sitting in its own
 * library, enclosed within its own namespace. At the very core lies the osg
 * library. This contains the OpenSceneGraph's central classes and, at the
 * bare minimum, it is all users need to write an OpenSceneGraph program
 * in C++. 
 * 
 * Around and alongside this sit other supporting libraries, such as osgUtil
 * (containing visitors for app traversals, cull traversals, scene graph
 * optimizers and so on), osgDB (for handling plug-ins, shared library loading,
 * database reading and writing and the like), osgText, osgParticle, etc.
 * 
 * Extensive online documentation is available from the OSG
 * <a href="http://www.openscenegraph.org/projects/osg/wiki/Support">
 * Support</a> section to help in using Open Scene Graph.
 * 
 * The project's original reference guides generated by Doxygen from the source
 * code may be downloaded as a single file from the OSG
 * <a href="http://www.openscenegraph.org/projects/osg/wiki/Support/ReferenceGuides">
 * Reference Guides</a> section.
 * 
 * To download source code, binaries, dependencies and sample
 * datasets visit the OSG
 * <a href="http://www.openscenegraph.org/projects/osg/wiki/Downloads">
 * Download</a> page.
 * 
 * For more about dependencies see the OSG 
 * <a href="http://www.openscenegraph.org/projects/osg/wiki/Downloads/Dependencies">
 * Dependencies</a> page.
 * 
 * The documentation you are looking at can be downloaded from
 * <a href="http://doc.systest.ch">doc.systest.ch</a>. 
 *   
 * Enjoy! 
 */
 
/*!
 * \dir docgen
 * 
 * This directory is used as the working directory for documentation
 * creation. It is not part of the OSG. 
 */
